﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 载体地铁信息仓储层
    /// </summary>
    public class RB_CarrierMetroRepository : BaseRepository<RB_CarrierMetro>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_CarrierMetro); } }
        /// <summary>
        /// 载体信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_CarrierMetro_Extend> GetCarrierMetroPageList(int pageIndex, int pageSize, out long rowCount, RB_CarrierMetro_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE  {nameof(RB_CarrierMetro_Extend.Status)}=0");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_CarrierMetro_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_CarrierMetro_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.CarrierId > 0)
                {
                    builder.Append($" AND {nameof(RB_CarrierMetro_Extend.CarrierId)}={query.CarrierId}");
                }
                if (!string.IsNullOrWhiteSpace(query.MetroNum))
                {
                    builder.Append($" AND {nameof(RB_CarrierMetro_Extend.MetroNum)} like '%{query.MetroNum}%'");
                }
                if (!string.IsNullOrWhiteSpace(query.MetroName))
                {
                    builder.Append($" AND {nameof(RB_CarrierMetro_Extend.MetroName)} like '%{query.MetroName}%'");
                }
                if (!string.IsNullOrWhiteSpace(query.CarrierIds))
                {
                    builder.Append($" AND {nameof(RB_CarrierMetro_Extend.CarrierId)} in({query.CarrierIds})  ");
                }
            }
            return GetPage<RB_CarrierMetro_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 载体信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_CarrierMetro_Extend> GetCarrierMetroList(RB_CarrierMetro_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_CarrierMetro_Extend.Status)}=0 ");
            if (query != null)
            {

                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_CarrierMetro_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_CarrierMetro_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.CarrierId > 0)
                {
                    builder.Append($" AND {nameof(RB_CarrierMetro_Extend.CarrierId)}={query.CarrierId}");
                }
                if (!string.IsNullOrWhiteSpace(query.MetroNum))
                {
                    builder.Append($" AND {nameof(RB_CarrierMetro_Extend.MetroNum)} like '%{query.MetroNum}%'");
                }
                if (!string.IsNullOrWhiteSpace(query.MetroName))
                {
                    builder.Append($" AND {nameof(RB_CarrierMetro_Extend.MetroName)} like '%{query.MetroName}%'");
                }
                if (!string.IsNullOrWhiteSpace(query.CarrierIds))
                {
                    builder.Append($" AND {nameof(RB_CarrierMetro_Extend.CarrierId)} in({query.CarrierIds})  ");
                }
            }
            return Get<RB_CarrierMetro_Extend>(builder.ToString()).ToList();
        }
    }
}
