﻿using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 拼团配置仓储层对象
    /// </summary>
    public class RB_GroupBuyConfigRepository : BaseRepository<RB_GroupBuyConfig>
    {
        /// <summary>
        /// 获取拼团配置实体
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public RB_GroupBuyConfig_Extend GetGroupBuyConfigRepository(RB_GroupBuyConfig_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM  rb_groupbuyconfig
WHERE 1=1 
");
            if (query != null)
            {
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_GroupBuyConfig_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_GroupBuyConfig_Extend.TenantId), query.TenantId);
                }
                if (query.GroupByConfigId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_GroupBuyConfig_Extend.GroupByConfigId), query.GroupByConfigId);
                }
            }
            return Get<RB_GroupBuyConfig_Extend>(builder.ToString()).FirstOrDefault();
        }
    }
}
