﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品规格仓储层
    /// </summary>
    public class RB_Product_SpecificationRepository : RepositoryBase<RB_Product_Specification>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Product_Specification_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Product_Specification_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Product_Specification.Status)}=0";
            if (dmodel.TenantId > 0) {
                where += $@" and {nameof(RB_Product_Specification.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0) {
                where += $@" and {nameof(RB_Product_Specification.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0) {
                where += $@" and {nameof(RB_Product_Specification.Id)}={dmodel.Id}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name)) {
                where += $@" and {nameof(RB_Product_Specification.Name)} like '%{dmodel.Name}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.Content)) {
                where += $@" and {nameof(RB_Product_Specification.Content)} like '%{dmodel.Content}%'";
            }

            string sql = $@"select * from RB_Product_Specification where {where} order by Id desc";
            return GetPage<RB_Product_Specification_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Product_Specification_Extend> GetList(RB_Product_Specification_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Product_Specification.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Product_Specification.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Product_Specification.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Product_Specification.Id)}={dmodel.Id}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and {nameof(RB_Product_Specification.Name)} like '%{dmodel.Name}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.Content))
            {
                where += $@" and {nameof(RB_Product_Specification.Content)} like '%{dmodel.Content}%'";
            }

            string sql = $@"select * from RB_Product_Specification where {where} order by Id desc";
            return Get<RB_Product_Specification_Extend>(sql).ToList();
        }
    }
}
