﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Extend.Point;
using Mall.Repository.Education;
using Mall.Repository.Point;
using Mall.Repository.User;
using VT.FW.DB;
using Mall.Common;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Module.User;

namespace Mall.Module.Education
{
    public class PointModule
    {
        /// <summary>
        /// 点数产品仓储
        /// </summary>
        private readonly RB_Point_GoodsRepository pointGoodsRepository = new RB_Point_GoodsRepository();
        private readonly RB_Point_OrderRepository pointOrderRepository = new RB_Point_OrderRepository();
        private readonly RB_Member_PointBalanceRepository memberPointBalanceRepository = new RB_Member_PointBalanceRepository();
        /// <summary>
        /// 会员信息
        /// </summary>
        private readonly RB_Member_UserRepository member_UserRepository = new RB_Member_UserRepository();
        private readonly RB_Point_CourseClassRepository pointCourseClassRepository = new RB_Point_CourseClassRepository();
        private readonly RB_Point_TeacherCourseRepository pointTeacherCourseRepository = new RB_Point_TeacherCourseRepository();
        private readonly RB_Point_TeacherCourseOrderRepository pointTeacherCourseOrderRepository = new RB_Point_TeacherCourseOrderRepository();
        /// <summary>
        /// 教育老师
        /// </summary>
        private readonly RB_Education_TeacherRepository education_TeacherRepository = new RB_Education_TeacherRepository();



        #region 用户基本信息
        public Model.Entity.User.RB_Member_User GetUserEntity(int UserId)
        {
            return member_UserRepository.GetEntity(UserId);
        }

        #endregion
        #region 点数商品
        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_Goods_Extend> GetPointGoodsList(RB_Point_Goods_Extend where)
        {
            return pointGoodsRepository.GetPointGoodsList(where);
        }



        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_Goods_Extend> GetPointGoodsPageList(int pageIndex, int pageSize, out long rowsCount, RB_Point_Goods_Extend where)
        {

            return pointGoodsRepository.GetPointGoodsPageList(pageIndex, pageSize, out rowsCount, where);
        }


        /// <summary>
        /// 新增/修改点数商品
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetPointGoods(RB_Point_Goods_Extend model)
        {
            if (model.ID == 0)
            {
                return pointGoodsRepository.Insert(model) > 0;
            }
            else
            {
                IDictionary<string, object> fileds = new Dictionary<string, object>
                {
                    { nameof(RB_Point_Goods_Extend.UpdateDate), model.UpdateDate },
                    { nameof(RB_Point_Goods_Extend.GoodsName), model.GoodsName },
                    { nameof(RB_Point_Goods_Extend.GivePoint), model.GivePoint },
                    { nameof(RB_Point_Goods_Extend.OriginalPrice), model.OriginalPrice },
                    { nameof(RB_Point_Goods_Extend.SellingPrice), model.SellingPrice },
                    { nameof(RB_Point_Goods_Extend.Sort), model.Sort },
                    { nameof(RB_Point_Goods_Extend.CostPrice), model.CostPrice },
                    { nameof(RB_Point_Goods_Extend.PonitNum), model.PonitNum }
                };
                IList<WhereHelper> auditrecordWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_Goods_Extend.ID),
                            FiledValue = model.ID,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_Goods_Extend.TenantId),
                            FiledValue = model.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_Goods_Extend.MallBaseId),
                            FiledValue = model.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };
                return pointGoodsRepository.Update(fileds, auditrecordWhereHelpers);
            }
        }


        /// <summary>
        /// 删除点数商品
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool DeletePointGoods(RB_Point_Goods_Extend model)
        {
            IDictionary<string, object> fileds = new Dictionary<string, object>
                {
                    { nameof(RB_Point_Goods_Extend.UpdateDate), model.UpdateDate },
                    { nameof(RB_Point_Goods_Extend.State),1 }
                };
            IList<WhereHelper> auditrecordWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_Goods_Extend.ID),
                            FiledValue = model.ID,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_Goods_Extend.TenantId),
                            FiledValue = model.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_Goods_Extend.MallBaseId),
                            FiledValue = model.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };
            return pointGoodsRepository.Update(fileds, auditrecordWhereHelpers);

        }

        #endregion

        #region 充值订单
        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_Order_Extend> GetPointOrderList(RB_Point_Order_Extend where)
        {
            return pointOrderRepository.GetPointOrderList(where);
        }



        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_Order_Extend> GetPointOrderPageList(int pageIndex, int pageSize, out long rowsCount, RB_Point_Order_Extend where)
        {
            return pointOrderRepository.GetPointOrderPageList(pageIndex, pageSize, out rowsCount, where);
        }

        /// <summary>
        /// 新增/修改点数订单
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool UpdatePointOrder(RB_Point_Order_Extend newModel)
        {
           
            //判断订单状态是否是待支付  2020-06-16 Add By:W
            var model = pointOrderRepository.GetEntity(newModel.ID);
            if (model == null)
            {
                return false;
            }
            var umodel = member_UserRepository.GetEntity(model.UserId);
            if (umodel == null)
            {
                return false;
            }
            if (model.State != 0)
            {
                return false;
            }
            if (model.Income != newModel.Income)
            {
                return false;
            }
            var trans = pointOrderRepository.DbTransaction;
            bool flag;
            if (model.ID > 0)
            {

                IDictionary<string, object> fileds = new Dictionary<string, object>
                {
                    { nameof(RB_Point_Order_Extend.PaymentTime), newModel.PaymentTime },
                    { nameof(RB_Point_Order_Extend.OrderStatus),2},
                    { nameof(RB_Point_Order_Extend.MerchantsNo), newModel.MerchantsNo }
                };
                IList<WhereHelper> auditrecordWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_Order_Extend.ID),
                            FiledValue = model.ID,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_Order_Extend.TenantId),
                            FiledValue = model.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_Order_Extend.MallBaseId),
                            FiledValue = model.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };

                RB_Member_PointBalance_Extend memberBalanceModel = new RB_Member_PointBalance_Extend
                {
                    UserId = model.UserId,
                    Type = Common.Enum.MarketingCenter.RecordTypeEnum.Income,
                    PonitNum = model.PonitNum + model.GivePoint,
                    Description = "在线购买" + model.PonitNum + "点" + (model.GivePoint > 0 ? ("赠送" + model.GivePoint+"点") : ""),
                    CreateDate = newModel.PaymentTime,
                    TenantId = model.TenantId,
                    MallBaseId = model.MallBaseId,
                    Remarks = "订单号：" + model.OrderNo + "在线购买支付" + model.Income + "元" + model.PonitNum + "点" + (model.GivePoint > 0 ? ("赠送" + model.GivePoint + "点") : ""),
                    PlatformType = model.OrderSource
                };
                memberPointBalanceRepository.Insert(memberBalanceModel, trans);

                flag = pointOrderRepository.Update(fileds, auditrecordWhereHelpers, trans);
                if (flag)
                {
                    IDictionary<string, object> filedsUser = new Dictionary<string, object>
                {
                    { nameof(Model.Entity.User.RB_Member_User.PointNum), umodel.PointNum+model.PonitNum+model.GivePoint }
                };
                    IList<WhereHelper> userWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(Model.Entity.User.RB_Member_User.Id),
                            FiledValue = umodel.Id,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(Model.Entity.User.RB_Member_User.TenantId),
                            FiledValue = umodel.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(Model.Entity.User.RB_Member_User.MallBaseId),
                            FiledValue = umodel.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };
                    member_UserRepository.Update(filedsUser, userWhereHelpers, trans);
                }
                pointOrderRepository.DBSession.Commit();
                return flag;
            }
            else
            {
                return false;
            }
        }



        /// <summary>
        /// 新增/修改点数订单
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int SetPointOrder(RB_Point_Order_Extend model)
        {
            if (model.ID == 0)
            {
                return pointOrderRepository.Insert(model);
            }
            return 0;
        }



        #endregion


        #region 点数明细
        /// <summary>
        /// 获取点数明细
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Member_PointBalance_Extend> GetUserPointDetailPageList(int pageIndex, int pageSize, out long count, RB_Member_PointBalance_Extend demodel)
        {
            return memberPointBalanceRepository.GetPointBalancePageList(pageIndex, pageSize, out count, demodel);
        }

        /// <summary>
        /// 获取用户点数
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        public int GetUserPointBalance(int userId)
        {
            return member_UserRepository.GetEntity(userId)?.PointNum ?? 0;
        }
        #endregion

        #region 教师列表

        /// <summary>
        /// 获取教师上课分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Point_TeacherCourse_Extend> GetPointTeacherCoursePageList(int pageIndex, int pageSize, out long count, RB_Point_TeacherCourse_Extend demodel)
        {
            var list = pointTeacherCourseRepository.GetPointTeacherCoursePageList(pageIndex, pageSize, out count, demodel);
            return list;
        }

        /// <summary>
        /// 获取教师课程明细
        /// </summary>
        /// <param name="courseId"></param>
        /// <param name="teacherId"></param>
        /// <param name="userInfo"></param>
        /// <returns></returns>
        public ApiResult GetPointTeacherCourseDetail(int courseId, int teacherId, AppletUserInfo userInfo)
        {
            var model = pointTeacherCourseRepository.GetEntity(courseId);
            if (model == null) { return ApiResult.Failed("课程不存在"); }
            if (model.TeacherId != teacherId) { return ApiResult.Failed("您不是该课程教师，无法查看"); }
            var classModel = pointCourseClassRepository.GetEntity(model.CourseClassId);
            if (classModel == null) { return ApiResult.Failed("课程分类不存在"); }
            //查询该课程下所有的订单
            var orderList = pointTeacherCourseOrderRepository.GetNormalPointOrderList(new RB_Point_TeacherCourseOrder_Extend() { TenantId = userInfo.TenantId, CourseId = courseId });
            return ApiResult.Success("", new
            {
                model.ID,
                model.CourseClassId,
                classModel.CourseClassType,
                CourseClassTypeName = classModel.CourseClassType.GetEnumName(),
                classModel.StudentNumType,
                StudentNumTypeName = classModel.StudentNumType.GetEnumName(),
                model.CourseName,
                model.TeacherId,
                StudyDate = model.StudyDate.ToString("yyyy-MM-dd"),
                model.StudyStartDate,
                model.StudyEndDate,
                model.PointNum,
                model.MinDuration,
                model.StudyDuration,
                DurationUnit = model.DurationUnit.GetEnumName(),
                OrderList = orderList.Select(x => new
                {
                    x.CourseId,
                    x.ID,
                    x.UserId,
                    x.UserName,
                    x.UserPhoto,
                    StudyDate = x.StudyDate.ToString("yyyy-MM-dd HH:mm"),
                    x.StudyDuration,
                    x.TotalStudyDuration,
                    DurationUnit = x.DurationUnit.GetEnumName(),
                    x.OrderStaus,
                    OrderStausName = x.OrderStaus.GetEnumName(),
                    x.IsSendRoom,
                    x.RoomInfo,
                    x.TotalPointNum,
                    x.ActualPointNum,
                    x.BasePointNum,
                    CreateDate = x.CreateDate.HasValue ? x.CreateDate.Value.ToString("yyyy-MM-dd HH:mm:ss") : "",
                })
            });
        }

        /// <summary>
        /// 获取教师id
        /// </summary>
        /// <param name="tid"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        public int GetUserTeacherId(int tid, int userId)
        {
            var model = education_TeacherRepository.GetTeacherList(new Model.Extend.Education.RB_Education_Teacher_Extend() { TenantId = tid, UserId = userId, TeacherStatus = 1 }).FirstOrDefault();
            return model?.ID ?? 0;
        }

        #endregion

        #region 在线课程分类
        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_CourseClass_Extend> GetPointCourseClassList(RB_Point_CourseClass_Extend where)
        {
            return pointCourseClassRepository.GetPointCourseClassList(where);
        }


        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_CourseClass_Extend> GetPointCourseClassPageList(int pageIndex, int pageSize, out long rowsCount, RB_Point_CourseClass_Extend where)
        {
            return pointCourseClassRepository.GetPointCourseClassPageList(pageIndex, pageSize, out rowsCount, where);
        }

        /// <summary>
        /// 新增/修改点数商品
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetPointCourseClass(RB_Point_CourseClass_Extend model)
        {
            if (model.ID == 0)
            {
                return pointCourseClassRepository.Insert(model) > 0;
            }
            else
            {
                IDictionary<string, object> fileds = new Dictionary<string, object>
                {
                    { nameof(RB_Point_CourseClass_Extend.UpdateDate), model.UpdateDate },
                    { nameof(RB_Point_CourseClass_Extend.CourseClassType), (int)model.CourseClassType },
                    { nameof(RB_Point_CourseClass_Extend.StudentNumType), model.StudentNumType },
                    { nameof(RB_Point_CourseClass_Extend.IsPublic), model.IsPublic },
                    { nameof(RB_Point_CourseClass_Extend.IsFree), model.IsFree },
                    { nameof(RB_Point_CourseClass_Extend.Sort), model.Sort },
                    { nameof(RB_Point_CourseClass_Extend.PointNum), model.PointNum },
                    { nameof(RB_Point_CourseClass_Extend.Duration), model.Duration },
                    { nameof(RB_Point_CourseClass_Extend.DurationUnit), model.DurationUnit },
                     { nameof(RB_Point_CourseClass_Extend.ClassPic), model.ClassPic },
                       { nameof(RB_Point_CourseClass_Extend.Title), model.Title }

            };
                IList<WhereHelper> auditrecordWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_CourseClass_Extend.ID),
                            FiledValue = model.ID,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_CourseClass_Extend.TenantId),
                            FiledValue = model.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_CourseClass_Extend.MallBaseId),
                            FiledValue = model.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };
                return pointCourseClassRepository.Update(fileds, auditrecordWhereHelpers);
            }
        }


        /// <summary>
        /// 删除点数课程分类
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool DeletePointCourseClass(RB_Point_CourseClass_Extend model)
        {
            IDictionary<string, object> fileds = new Dictionary<string, object>
                {
                    { nameof(RB_Point_CourseClass_Extend.UpdateDate), model.UpdateDate },
                    { nameof(RB_Point_CourseClass_Extend.State),1 }
                };
            IList<WhereHelper> auditrecordWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_CourseClass_Extend.ID),
                            FiledValue = model.ID,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_CourseClass_Extend.TenantId),
                            FiledValue = model.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_CourseClass_Extend.MallBaseId),
                            FiledValue = model.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };
            return pointCourseClassRepository.Update(fileds, auditrecordWhereHelpers);

        }
        #endregion


        #region  教师排课
        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_TeacherCourse_Extend> GetTeacherCourseList(RB_Point_TeacherCourse_Extend where)
        {
            return pointTeacherCourseRepository.GetTeacherCourseList(where);
        }


        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_TeacherCourse_Extend> GetTeacherCoursePageList(int pageIndex, int pageSize, out long rowsCount, RB_Point_TeacherCourse_Extend where)
        {
            return pointTeacherCourseRepository.GetTeacherCoursePageList(pageIndex, pageSize, out rowsCount, where);
        }



        /// <summary>
        /// 新增/修改老师排课
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetTeacherCourse(RB_Point_TeacherCourse_Extend model)
        {
            if (model.ID == 0)
            {
                return pointTeacherCourseRepository.Insert(model) > 0;
            }
            else
            {
                IDictionary<string, object> fileds = new Dictionary<string, object>
                {
                    { nameof(RB_Point_TeacherCourse_Extend.UpdateDate), model.UpdateDate },
                    { nameof(RB_Point_TeacherCourse_Extend.CourseClassId), model.CourseClassId },
                    { nameof(RB_Point_TeacherCourse_Extend.TeacherId), model.TeacherId },
                    { nameof(RB_Point_TeacherCourse_Extend.StudyDate), model.StudyDate },
                    { nameof(RB_Point_TeacherCourse_Extend.StudyStartDate), model.StudyStartDate },
                    { nameof(RB_Point_TeacherCourse_Extend.StudyEndDate), model.StudyEndDate },
                    { nameof(RB_Point_TeacherCourse_Extend.PointNum), model.PointNum },
                    { nameof(RB_Point_TeacherCourse_Extend.CourseName), model.CourseName },
                    { nameof(RB_Point_TeacherCourse_Extend.MinDuration), model.MinDuration },
                    { nameof(RB_Point_TeacherCourse_Extend.StudyDuration), model.StudyDuration },
                    { nameof(RB_Point_TeacherCourse_Extend.RoomId), model.RoomId },
                    { nameof(RB_Point_TeacherCourse_Extend.DurationUnit), model.DurationUnit },
                };
                IList<WhereHelper> auditrecordWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_TeacherCourse_Extend.ID),
                            FiledValue = model.ID,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_TeacherCourse_Extend.TenantId),
                            FiledValue = model.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_TeacherCourse_Extend.MallBaseId),
                            FiledValue = model.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };
                return pointTeacherCourseRepository.Update(fileds, auditrecordWhereHelpers);
            }
        }


        /// <summary>
        /// 删除老师排课
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool DeleteTeacherCourse(RB_Point_TeacherCourse_Extend model)
        {
            IDictionary<string, object> fileds = new Dictionary<string, object>
                {
                    { nameof(RB_Point_TeacherCourse_Extend.UpdateDate), model.UpdateDate },
                    { nameof(RB_Point_TeacherCourse_Extend.State),1 }
                };
            IList<WhereHelper> auditrecordWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_TeacherCourse_Extend.ID),
                            FiledValue = model.ID,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_TeacherCourse_Extend.TenantId),
                            FiledValue = model.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_TeacherCourse_Extend.MallBaseId),
                            FiledValue = model.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };
            return pointTeacherCourseRepository.Update(fileds, auditrecordWhereHelpers);

        }
        #endregion

        #region 订单

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_TeacherCourseOrder_Extend> GetPointOrderList(RB_Point_TeacherCourseOrder_Extend where)
        {
            return pointTeacherCourseOrderRepository.GetPointOrderList(where);
        }


        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_TeacherCourseOrder_Extend> GetPointOrderPageList(int pageIndex, int pageSize, out long rowsCount, RB_Point_TeacherCourseOrder_Extend where)
        {
            return pointTeacherCourseOrderRepository.GetPointOrderPageList(pageIndex, pageSize, out rowsCount, where);
        }

        /// <summary>
        /// 获取订单详情
        /// </summary>
        /// <param name="orderId"></param>
        /// <returns></returns>
        public RB_Point_TeacherCourseOrder_Extend GetPointOrderInfo(int orderId, int TenantId)
        {
            var model = pointTeacherCourseOrderRepository.GetPointOrderInfo(new RB_Point_TeacherCourseOrder_Extend() { ID = orderId, TenantId = TenantId });
            return model;
        }



        public bool SetTeacherCourseOrder(RB_Point_TeacherCourseOrder_Extend model)
        {
            bool flag = false;
            var trans = pointTeacherCourseOrderRepository.DbTransaction;
            var umodel = member_UserRepository.GetEntity(model.UserId);
            if (umodel == null)
            {
                return false;
            }
            int orderId = 0;
            if (model.ID == 0)
            {
                orderId = pointTeacherCourseOrderRepository.Insert(model, trans);
                flag = orderId > 0;
            }
            else
            {
                orderId = model.ID;
                IDictionary<string, object> fileds = new Dictionary<string, object>
                {
                    { nameof(RB_Point_TeacherCourseOrder_Extend.OrderStaus), (int)model.OrderStaus },
                    { nameof(RB_Point_TeacherCourseOrder_Extend.UpdateDate), model.UpdateDate }
                };
                IList<WhereHelper> auditrecordWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_TeacherCourseOrder_Extend.ID),
                            FiledValue = model.ID,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_TeacherCourseOrder_Extend.TenantId),
                            FiledValue = model.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_TeacherCourseOrder_Extend.MallBaseId),
                            FiledValue = model.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };
                flag = pointTeacherCourseOrderRepository.Update(fileds, auditrecordWhereHelpers, trans);
            }
            if (model.OrderStaus == Common.Enum.Point.OrderStausEnum.Paid && model.TotalPointNum > 0)
            {
                RB_Member_PointBalance_Extend memberBalanceModel = new RB_Member_PointBalance_Extend
                {
                    OrderId = orderId,
                    UserId = model.UserId,
                    Type = Common.Enum.MarketingCenter.RecordTypeEnum.Expend,
                    PonitNum = model.TotalPointNum,
                    Description = "购买直播课程消费" + model.TotalPointNum + "点",
                    CreateDate = System.DateTime.Now,
                    TenantId = model.TenantId,
                    MallBaseId = model.MallBaseId,
                    Remarks = "上课时间：" + model.StudyDate.ToString("yyyy-MM-dd HH:mm") + "时长" + model.TotalStudyDuration.ToString("f2") + Common.Plugin.EnumHelper.GetEnumName(model.DurationUnit),
                    PlatformType = umodel.Source
                };
                memberPointBalanceRepository.Insert(memberBalanceModel, trans);

                IDictionary<string, object> filedsUser = new Dictionary<string, object>
                {
                    { nameof(Model.Entity.User.RB_Member_User.PointNum), umodel.PointNum-model.TotalPointNum }
                };
                IList<WhereHelper> userWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(Model.Entity.User.RB_Member_User.Id),
                            FiledValue = umodel.Id,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(Model.Entity.User.RB_Member_User.TenantId),
                            FiledValue = umodel.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(Model.Entity.User.RB_Member_User.MallBaseId),
                            FiledValue = umodel.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };
                member_UserRepository.Update(filedsUser, userWhereHelpers, trans);

            }
            pointTeacherCourseOrderRepository.DBSession.Commit();
            return flag;
        }




        public bool DeleteCourseOrder(RB_Point_TeacherCourseOrder_Extend model)
        {
            IDictionary<string, object> fileds = new Dictionary<string, object>
                {
                    { nameof(RB_Point_TeacherCourseOrder_Extend.State),1 },
                    { nameof(RB_Point_TeacherCourseOrder_Extend.UpdateDate), model.UpdateDate },
                };
            IList<WhereHelper> auditrecordWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_TeacherCourseOrder_Extend.ID),
                            FiledValue = model.ID,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_TeacherCourseOrder_Extend.TenantId),
                            FiledValue = model.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_TeacherCourseOrder_Extend.MallBaseId),
                            FiledValue = model.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };

            return pointTeacherCourseOrderRepository.Update(fileds, auditrecordWhereHelpers);
        }


        /// <summary>
        /// 确认订单
        /// </summary>
        /// <param name="list"></param>
        /// <returns></returns>
        public bool ConfirmTeacherCourseOrder(List<RB_Point_TeacherCourseOrder_Extend> list)
        {
            bool flag = false;
            var trans = pointTeacherCourseOrderRepository.DbTransaction;

            foreach (var model in list)
            {
                IDictionary<string, object> fileds = new Dictionary<string, object>
                {
                    { nameof(RB_Point_TeacherCourseOrder_Extend.OrderStaus), (int)model.OrderStaus },
                    { nameof(RB_Point_TeacherCourseOrder_Extend.IsSendRoom),1 },
                    { nameof(RB_Point_TeacherCourseOrder_Extend.UpdateDate), model.UpdateDate },
                    { nameof(RB_Point_TeacherCourseOrder_Extend.RoomInfo), model.RoomInfo }
                };
                IList<WhereHelper> auditrecordWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_TeacherCourseOrder_Extend.ID),
                            FiledValue = model.ID,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_TeacherCourseOrder_Extend.TenantId),
                            FiledValue = model.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_TeacherCourseOrder_Extend.MallBaseId),
                            FiledValue = model.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };

                flag = pointTeacherCourseOrderRepository.Update(fileds, auditrecordWhereHelpers, trans);
                pointTeacherCourseOrderRepository.DBSession.Commit();
                if (flag)//推送房间信息
                {
                    List<string> openidList = new List<string>();
                    openidList.Add(model.OpenId);
                    new MiniProgramMsgModule().SendCourseOrderTplMsg(model.TenantId, model.MallBaseId, openidList, model.CourseName,model.RoomInfo, model.StudyDate.ToString("MM月dd日"));
                }
            }
           
            return flag;
        }

        /// <summary>
        /// 完成订单
        /// </summary>
        /// <param name="list"></param>
        /// <returns></returns>
        public bool CompleteTeacherCourseOrder(RB_Point_TeacherCourseOrder_Extend model)
        {
            bool flag = false;

            var umodel = member_UserRepository.GetEntity(model.UserId);
            if (umodel == null)
            {
                return false;
            }
            var trans = pointTeacherCourseOrderRepository.DbTransaction;

            IDictionary<string, object> fileds = new Dictionary<string, object>
                {
                    { nameof(RB_Point_TeacherCourseOrder_Extend.OrderStaus), (int)model.OrderStaus },
                    { nameof(RB_Point_TeacherCourseOrder_Extend.UpdateDate), model.UpdateDate },
                    { nameof(RB_Point_TeacherCourseOrder_Extend.ActualPointNum), model.ActualPointNum }
                };
            IList<WhereHelper> auditrecordWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_TeacherCourseOrder_Extend.ID),
                            FiledValue = model.ID,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_TeacherCourseOrder_Extend.TenantId),
                            FiledValue = model.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_TeacherCourseOrder_Extend.MallBaseId),
                            FiledValue = model.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };
            flag = pointTeacherCourseOrderRepository.Update(fileds, auditrecordWhereHelpers, trans);
            if (flag && model.ActualPointNum != model.TotalPointNum)//判断是否需要扣除或者增加点数
            {
                RB_Member_PointBalance_Extend memberBalanceModel = new RB_Member_PointBalance_Extend
                {
                    OrderId = model.ID,
                    UserId = model.UserId,
                   
                    CreateDate = System.DateTime.Now,
                    TenantId = model.TenantId,
                    MallBaseId = model.MallBaseId,
                    Remarks = "上课时间：" + model.StudyDate.ToString("yyyy-MM-dd HH:mm") + "时长" + model.TotalStudyDuration.ToString("f2") + Common.Plugin.EnumHelper.GetEnumName(model.DurationUnit),
                    PlatformType = umodel.Source
                };

                int allTotalPointNum = 0;

                if (model.ActualPointNum > model.TotalPointNum)
                {
                    allTotalPointNum = model.ActualPointNum - model.TotalPointNum;
                    if ((umodel.PointNum - allTotalPointNum) < 0)
                    {
                        allTotalPointNum = 0;
                        memberBalanceModel.PonitNum = (umodel.PointNum - allTotalPointNum);
                    }
                    else
                    {
                        allTotalPointNum = (umodel.PointNum - allTotalPointNum);
                        memberBalanceModel.PonitNum = (model.ActualPointNum - model.TotalPointNum);
                    }
                    memberBalanceModel.Type = Common.Enum.MarketingCenter.RecordTypeEnum.Expend;
                    memberBalanceModel.Description = "购买直播课程消费" + (model.ActualPointNum - model.TotalPointNum) + "点";
                 
                }
                else if (model.ActualPointNum < model.TotalPointNum)
                {
                    allTotalPointNum = model.TotalPointNum - model.ActualPointNum;
                    allTotalPointNum = (umodel.PointNum + allTotalPointNum);
                    memberBalanceModel.PonitNum = (model.TotalPointNum - model.ActualPointNum);
                    memberBalanceModel.Type = Common.Enum.MarketingCenter.RecordTypeEnum.Income;
                    memberBalanceModel.Description = "购买直播课程退费" + (model.TotalPointNum - model.ActualPointNum) + "点";
                   
                }
                IDictionary<string, object> filedsUser = new Dictionary<string, object>
                {
                    { nameof(Model.Entity.User.RB_Member_User.PointNum), allTotalPointNum }
                };
                IList<WhereHelper> userWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(Model.Entity.User.RB_Member_User.Id),
                            FiledValue = umodel.Id,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(Model.Entity.User.RB_Member_User.TenantId),
                            FiledValue = umodel.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(Model.Entity.User.RB_Member_User.MallBaseId),
                            FiledValue = umodel.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };
                memberPointBalanceRepository.Insert(memberBalanceModel, trans);
                member_UserRepository.Update(filedsUser, userWhereHelpers, trans);

            }

            pointTeacherCourseOrderRepository.DBSession.Commit();
            return flag;
        }

        #endregion


        #region 公用
        public bool GetTimeSpan(DateTime timeStr, string StartTime, string EndTime)
        {
            //判断当前时间是否在工作时间段内

            TimeSpan dspWorkingDayAM = DateTime.Parse(StartTime).TimeOfDay;
            TimeSpan dspWorkingDayPM = DateTime.Parse(EndTime).TimeOfDay;
            TimeSpan dspNow = timeStr.TimeOfDay;
            if (dspNow >= dspWorkingDayAM && dspNow <= dspWorkingDayPM)
            {
                return true;
            }
            return false;
        }

        #endregion
    }
}
