﻿using Mall.Common.Plugin;
using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Extend.MarketingCenter;
using Mall.Repository;
using Mall.Repository.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Module.MarketingCenter
{
    public class CouponModule
    {
        private RB_CouponRepository couponRepository = new RB_CouponRepository();
        private RB_DiscountCouponRepository discountCouponRepository = new RB_DiscountCouponRepository();
        private RB_DiscountCoupon_ProductRepository productRepository = new RB_DiscountCoupon_ProductRepository();
        #region 卡券列表
        /// <summary>
        /// 卡券信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Coupon_Extend> GetCouponPageList(int pageIndex, int pageSize, out long rowCount, RB_Coupon_Extend query)
        {
            return couponRepository.GetCouponPageList(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 卡券信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Coupon_Extend> GetCouponList(RB_Coupon_Extend query)
        {
            return couponRepository.GetCouponList(query);

        }

        public bool AddOrUpdateCoupon(RB_Coupon_Extend model)
        {
            if (model.ID == 0)
            {
                return couponRepository.Insert(model) > 0;
            }
            else
            {
                return couponRepository.Update(model);
            }
        }


        /// <summary>
        /// 删除卡券
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelCoupon(int id, int uid, int mallBaseId)
        {
            try
            {
                Dictionary<string, object> cols = new Dictionary<string, object>()
                {
                    { nameof(RB_Coupon.Status),1},
                    { nameof(RB_Coupon.UpdateDate),DateTime.Now},
                };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Coupon.ID),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Coupon.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Coupon.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
            };
                return couponRepository.Update(cols, wheres1);

            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelCoupon");
                return false;
            }
        }



        #endregion

        #region 优惠券
        /// <summary>
        /// 优惠券信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_DiscountCoupon_Extend> GetDiscountCouponPageList(int pageIndex, int pageSize, out long rowCount, RB_DiscountCoupon_Extend query)
        {
            return discountCouponRepository.GetDiscountCouponPageList(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 优惠券信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_DiscountCoupon_Extend> GetDiscountCouponList(RB_DiscountCoupon_Extend query)
        {
            return discountCouponRepository.GetDiscountCouponList(query);

        }

        /// <summary>
        /// 新增/修改优惠券
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateDiscountCoupon(RB_DiscountCoupon_Extend model)
        {
            bool flag = false;
            var trans = discountCouponRepository.DbTransaction;
            try
            {
                int id = 0;
                if (model.ID == 0)
                {
                    id = discountCouponRepository.Insert(model, trans);
                    if (id > 0 && model.ProductList != null && model.ProductList.Any())
                    {
                        model.ProductList.ForEach(x => x.MallBaseId = model.MallBaseId);
                        model.ProductList.ForEach(x => x.TenantId = model.TenantId);
                        model.ProductList.ForEach(x => x.CreateDate = model.CreateDate);
                        model.ProductList.ForEach(x => x.UpdateDate = model.UpdateDate);
                        model.ProductList.ForEach(x => x.DiscountCouponId = id);
                        flag = productRepository.InsertBatch(model.ProductList, trans);
                    }
                    flag = id > 0;
                }
                else
                {
                    id = model.ID;
                    flag = discountCouponRepository.Update(model, trans);
                    var listProduct = productRepository.GetCouponProductList(new RB_DiscountCoupon_Product { TenantId = model.TenantId, MallBaseId = model.MallBaseId, DiscountCouponId = id });
                    if (listProduct != null && listProduct.Any())
                    {
                        foreach (var item in model.ProductList)
                        {
                            IDictionary<string, object> fileds = new Dictionary<string, object>()
                         {
                            { nameof(RB_DiscountCoupon_Product.Status),1},
                             { nameof(RB_DiscountCoupon_Product.UpdateDate),model.UpdateDate},
                          };
                            IList<WhereHelper> whereHelpers = new List<WhereHelper>()
                        {
                            new WhereHelper (){ FiledName=nameof(RB_DiscountCoupon_Product.ID),FiledValue=item.ID,OperatorEnum=OperatorEnum.Equal}
                        };
                            flag = productRepository.Update(fileds, whereHelpers, trans);
                        }
                    }

                    if (model.ProductList != null && model.ProductList.Any())
                    {
                        model.ProductList.ForEach(x => x.MallBaseId = model.MallBaseId);
                        model.ProductList.ForEach(x => x.TenantId = model.TenantId);
                        model.ProductList.ForEach(x => x.CreateDate = model.CreateDate);
                        model.ProductList.ForEach(x => x.UpdateDate = model.UpdateDate);
                        model.ProductList.ForEach(x => x.DiscountCouponId = id);
                        flag = productRepository.InsertBatch(model.ProductList, trans);
                    }
                }
                discountCouponRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateDiscountCoupon");
                discountCouponRepository.DBSession.Rollback("AddOrUpdateDiscountCoupon");
                return false;
            }
            return flag;
        }


        /// <summary>
        /// 删除优惠券
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelDiscountCoupon(int id, int uid, int mallBaseId)
        {
            try
            {
                Dictionary<string, object> cols = new Dictionary<string, object>()
                {
                    { nameof(RB_Coupon.Status),1},
                    { nameof(RB_Coupon.UpdateDate),DateTime.Now},
                };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Coupon.ID),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Coupon.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Coupon.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
            };
                return discountCouponRepository.Update(cols, wheres1);

            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelDiscountCoupon");
                return false;
            }
        }
        #endregion 


    }
}
