﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Extend.User;
using Mall.Repository;
using Mall.Repository.User;

namespace Mall.Module.User
{
    /// <summary>
    /// 小程序用户中心配置处理类
    /// </summary>
    public class MiniProgramUserCenterConfigModule
    {
        /// <summary>
        /// 小程序用户中心配置仓储层对象
        /// </summary>
        private RB_MiniProgram_UserCenterConfigRepository configRepository = new RB_MiniProgram_UserCenterConfigRepository();

        /// <summary>
        /// 根据查询条件获取小程序用户中心配置实体
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public RB_MiniProgram_UserCenterConfig_Extend GetEntityExtModule(RB_MiniProgram_UserCenterConfig_Extend query)
        {
            var extModel = configRepository.GetEntityExtRepository(query);
            if (extModel == null)
            {
                extModel = new RB_MiniProgram_UserCenterConfig_Extend();
            }
            return extModel;
        }

        /// <summary>
        /// 添加修改用户中心配置信息
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetMiniUserCenterConfig(RB_MiniProgram_UserCenterConfig_Extend extModel)
        {
            bool flag = false;
            if (extModel.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_MiniProgram_UserCenterConfig_Extend.DefaultBgImg),extModel.DefaultBgImg},
                    { nameof(RB_MiniProgram_UserCenterConfig_Extend.MemberBgImg),extModel.MemberBgImg},
                    { nameof(RB_MiniProgram_UserCenterConfig_Extend.VipBgImg),extModel.VipBgImg},
                    { nameof(RB_MiniProgram_UserCenterConfig_Extend.HeadStyle),extModel.HeadStyle},
                    { nameof(RB_MiniProgram_UserCenterConfig_Extend.HeadStyleStr),extModel.HeadStyleStr},
                    { nameof(RB_MiniProgram_UserCenterConfig_Extend.IsShowFavorite),extModel.IsShowFavorite},
                    { nameof(RB_MiniProgram_UserCenterConfig_Extend.MyFavoriteImg),extModel.MyFavoriteImg},
                    { nameof(RB_MiniProgram_UserCenterConfig_Extend.MyFootPrintImg),extModel.MyFootPrintImg},
                    { nameof(RB_MiniProgram_UserCenterConfig_Extend.IsShowOrderNav),extModel.IsShowOrderNav},
                    { nameof(RB_MiniProgram_UserCenterConfig_Extend.NoPayImg),extModel.NoPayImg},
                    { nameof(RB_MiniProgram_UserCenterConfig_Extend.NoDeliveryImg),extModel.NoDeliveryImg},
                    { nameof(RB_MiniProgram_UserCenterConfig_Extend.NoReciveImg),extModel.NoReciveImg},
                    { nameof(RB_MiniProgram_UserCenterConfig_Extend.NoEvaluation),extModel.NoEvaluation},
                    { nameof(RB_MiniProgram_UserCenterConfig_Extend.AfterSales),extModel.AfterSales},
                    { nameof(RB_MiniProgram_UserCenterConfig_Extend.IsShowAccountNav),extModel.IsShowAccountNav},
                    { nameof(RB_MiniProgram_UserCenterConfig_Extend.IntegralName),extModel.IntegralName},
                    { nameof(RB_MiniProgram_UserCenterConfig_Extend.IntegralImg),extModel.IntegralImg},
                    { nameof(RB_MiniProgram_UserCenterConfig_Extend.BalanceName),extModel.BalanceName},
                    { nameof(RB_MiniProgram_UserCenterConfig_Extend.BalanceImg),extModel.BalanceImg},
                    { nameof(RB_MiniProgram_UserCenterConfig_Extend.CouponsName),extModel.CouponsName},
                    { nameof(RB_MiniProgram_UserCenterConfig_Extend.CouponsImg),extModel.CouponsImg},
                    { nameof(RB_MiniProgram_UserCenterConfig_Extend.CardName),extModel.CardName},
                    { nameof(RB_MiniProgram_UserCenterConfig_Extend.CardImg),extModel.CardImg},
                    { nameof(RB_MiniProgram_UserCenterConfig_Extend.IsShowMenuNav),extModel.IsShowMenuNav},
                    { nameof(RB_MiniProgram_UserCenterConfig_Extend.MenuNavTitle),extModel.MenuNavTitle},
                    { nameof(RB_MiniProgram_UserCenterConfig_Extend.MenuNavStyle),extModel.MenuNavStyle},
                    { nameof(RB_MiniProgram_UserCenterConfig_Extend.MenuNavJson),extModel.MenuNavJson},
                };
                flag = configRepository.Update(fileds, new WhereHelper(nameof(RB_MiniProgram_UserCenterConfig_Extend.Id), extModel.Id));
            }
            else
            {
                int NewId = configRepository.Insert(extModel);
                extModel.Id = NewId;
                flag = NewId > 0;
            }
            return flag;
        }
    }
}
