﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Extend.User;
using Mall.Repository;
using Mall.Repository.User;


namespace Mall.Module.User
{
    /// <summary>
    /// 海报处理类
    /// </summary>
    public class PosterModule
    {
        /// <summary>
        /// 分销海报仓储层对象
        /// </summary>
        private RB_MiniProgram_FenXiaoPosterRepository fenXiaoPosterRepository = new RB_MiniProgram_FenXiaoPosterRepository();


        /// <summary>
        /// 根据查询条件获取分销海报实体
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public RB_MiniProgram_FenXiaoPoster_Extend GetFenXiaoPosterEntityModule(RB_MiniProgram_FenXiaoPoster_Extend query)
        {
            return fenXiaoPosterRepository.GetEntityExtRepository(query);
        }

        /// <summary>
        /// 添加修改分销海报
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetFenXiaoPoster(RB_MiniProgram_FenXiaoPoster_Extend extModel) 
        {
            bool flag = false;
            if (extModel.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.PosterBgImg),extModel.PosterBgImg},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.IsShowHead),extModel.IsShowHead},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.HeadSize),extModel.HeadSize},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.HeadPaddingTop),extModel.HeadPaddingTop},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.HeadPaddingLeft),extModel.HeadPaddingLeft},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.IsShowNick),extModel.IsShowNick},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.NickSize),extModel.NickSize},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.NickPaddingTop),extModel.NickPaddingTop},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.NickPaddingLeft),extModel.NickPaddingLeft},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.IsShowQrCode),extModel.IsShowQrCode},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.QrCodeSize),extModel.QrCodeSize},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.QrCodePaddingTop),extModel.QrCodePaddingTop},
                    { nameof(RB_MiniProgram_FenXiaoPoster_Extend.QrCodePaddingLeft),extModel.QrCodePaddingLeft},
                };
                flag = fenXiaoPosterRepository.Update(fileds, new WhereHelper(nameof(RB_MiniProgram_FenXiaoPoster_Extend.Id), extModel.Id));
            }
            else
            {
                int NewId = fenXiaoPosterRepository.Insert(extModel);
                extModel.Id = NewId;
                flag = NewId > 0;
            }
            return flag;
        }
    }
}
