﻿using VT.FW.DB;
using Mall.Model.Entity.BaseSetUp;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Extend.BaseSetUp
{
    /// <summary>
    /// 分类包邮规则
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_FreeShipping_Extend : RB_FreeShipping
    {
        /// <summary>
        /// 分类列表
        /// </summary>
        public List<RB_FreeShippingCategory_Extend> CategoryList { get; set; }

        /// <summary>
        /// 商品分类包邮规则
        /// </summary>
        public string CategoryIds { get; set; }

        /// <summary>
        /// 是否启用包邮总规则0-否，1-是
        /// </summary>
        public int IsFreeShipping { get; set; }

        /// <summary>
        /// 商品分类ID
        /// </summary>
        public int CategoryId { get; set; }
    }

    /// <summary>
    /// 包邮满足的订单商品
    /// </summary>
    public class FreeShippingGoodsDetail { 
        public int FreeShipping { get; set; }
        public string Name { get; set; }
        public int GoodsId { get; set; }
        public string SpecificationKey { get; set; }
    }
}
