﻿using Mall.Model.Entity.Reserve;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Extend.Reserve
{

    /// <summary>
    ///  服务人员扩展表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Reserve_ServicePersonal_Extend : RB_Reserve_ServicePersonal
    {
        /// <summary>
        /// 标签
        /// </summary>
        public List<string> LableNameList { get; set; }

        /// <summary>
        /// 预约数
        /// </summary>
        public int OrderNum { get; set; }
        /// <summary>
        /// 评价数
        /// </summary>
        public int CommentNum { get; set; }

        /// <summary>
        /// 订单人数
        /// </summary>
        public int OrderGuestNum { get; set; }


        /// <summary>
        /// 排名（并列）
        /// </summary>
        public int Rank { get; set; }


        /// <summary>
        /// 商品分类id
        /// </summary>
        public int[] GoodsClassId { get; set; }

        /// <summary>
        /// 店铺名称
        /// </summary>
        public string StoreName { get; set; }

        public string StoreAddress { get; set; }

        /// <summary>
        /// 日期
        /// </summary>
        public List<string> TargetDateStrList { get; set; }

        /// <summary>
        /// 可预约时间
        /// </summary>

        public List<RB_Reserve_ServiceTargetDate_Extend> ServiceTargetDateList { get; set; }


        /// <summary>
        /// 商品/分类id
        /// </summary>
        public List<RB_Reserve_ServicePersonalProduct_Extend> ProductList { get; set; }
    }
}
