﻿using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 拼团配置表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_GroupBuyConfig
    {
        /// <summary>
        /// 拼团配置主键编号
        /// </summary>
        public int GroupByConfigId { get; set; }

        /// <summary>
        /// 是否开启分销(1-开启)
        /// </summary>
        public int Is_Share { get; set; }

        /// <summary>
        /// 是否开启区域允许购买(1-开启)
        /// </summary>
        public int Is_Territorial_Limitation { get; set; }

        /// <summary>
        /// 支付方式[online_pay-线上支付,huodao-货到付款,balance-余额支付]
        /// </summary>
        public string Payment_Type { get; set; }

        /// <summary>
        /// 发货方式[express-快递配送,offline-到店自提,city-同城配送]
        /// </summary>
        public string Send_Type { get; set; }

        /// <summary>
        /// 优惠券(1-开启)
        /// </summary>
        public int Is_Coupon { get; set; }

        /// <summary>
        /// 超级会员卡(1-开启)
        /// </summary>
        public int SVIP_Status { get; set; }

        /// <summary>
        /// 会员价[1-开启]
        /// </summary>
        public int Is_Member_Price { get; set; }

        /// <summary>
        /// 积分[1-开启]
        /// </summary>
        public int Is_Integral { get; set; }

        /// <summary>
        /// 活动规则
        /// </summary>
        public string RuleText { get; set; }

        /// <summary>
        /// 商品海报
        /// </summary>
        public string Goods_Poster { get; set; }

        /// <summary>
        /// 拼团广告状态(1-开启)
        /// </summary>
        public int Is_Advertisement { get; set; }

        /// <summary>
        /// 小程序Id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 商户Id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 微信拼团成功通知
        /// </summary>
        public string WeChat_pintuan_success_notice { get; set; }

        /// <summary>
        /// 微信拼团失败通知
        /// </summary>
        public string WeChat_pintuan_fail_notice { get; set; }

        /// <summary>
        /// 广告样式
        /// </summary>
        public int Style { get; set; }

        /// <summary>
        /// 轮播图JSON
        /// </summary>
        public string BannerJson { get; set; }

        /// <summary>
        /// 广告JSON
        /// </summary>
        public string MagicJson { get; set; }
    }
}
