﻿using Mall.Common;
using Mall.Common.Enum;
using Mall.Model.Entity.Finance;
using Mall.Model.Extend.Finance;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Finance
{
    /// <summary>
    /// 客户账户仓储
    /// </summary>
    public partial class RB_ClientBankAccountRepository : BaseRepository<RB_ClientBankAccount>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_ClientBankAccount); } }
        /// <summary>
        /// 获取客户账户分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="model"></param>
        /// <param name="count"></param>
        /// <returns></returns>
        public List<RB_ClientBankAccount_Extend> GetPageList(int pageIndex, int pageSize, RB_ClientBankAccount_Extend model, out long count)
        {
            string where = " WHERE 1=1 ";
            where += string.Format(" AND a." + nameof(RB_ClientBankAccount_Extend.Status) + "={0}", (int)DateStateEnum.Normal);
            if (model.RB_Group_Id > 0)
            {
                where += string.Format(" AND a." + nameof(RB_ClientBankAccount_Extend.RB_Group_Id) + "={0}", model.RB_Group_Id);
            }
            if (model.RB_Branch_Id >= 0)
            {
                where += string.Format(" AND a." + nameof(RB_ClientBankAccount_Extend.RB_Branch_Id) + "={0}", model.RB_Branch_Id);
            }
            if (model.Type > 0)
            {
                where += string.Format(" AND a." + nameof(RB_ClientBankAccount_Extend.Type) + "={0}", (int)model.Type);
            }
            if (!string.IsNullOrEmpty(model.AccountAlias))
            {
                where += string.Format(" AND a." + nameof(RB_ClientBankAccount_Extend.AccountAlias) + " like '%{0}%' ", model.AccountAlias);
            }
            if (!string.IsNullOrEmpty(model.OpenBankName))
            {
                where += string.Format(" AND a." + nameof(RB_ClientBankAccount_Extend.OpenBankName) + " like '%{0}%' ", model.OpenBankName);
            }
            if (!string.IsNullOrEmpty(model.CardNum))
            {
                where += string.Format(" AND a." + nameof(RB_ClientBankAccount_Extend.CardNum) + " like '%{0}%' ", model.CardNum);
            }
            if (!string.IsNullOrEmpty(model.AccountHolder))
            {
                where += string.Format(" AND a." + nameof(RB_ClientBankAccount_Extend.AccountHolder) + " like '%{0}%' ", model.AccountHolder);
            }
            string sql = $@"select a.*  from {TableName} as a  {TableName}";
            return GetPage<RB_ClientBankAccount_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }
        /// <summary>
        /// 获取客户账户列表
        /// </summary>
        /// <param name="model"></param>
        /// <param name="AccountAlias"></param>
        /// <param name="ClientIdStr"></param>
        /// <returns></returns>
        public List<RB_ClientBankAccount> GetList(RB_ClientBankAccount model, string AccountAlias = "", string ClientIdStr = "")
        {
            string where = " WHERE 1=1 ";
            where += string.Format(" AND a." + nameof(RB_ClientBankAccount.Status) + "={0} ", (int)DateStateEnum.Normal);
            if (model.RB_Group_Id > 0)
            {
                where += string.Format(" AND a." + nameof(RB_ClientBankAccount.RB_Group_Id) + "={0} ", model.RB_Group_Id);
            }
            if (model.RB_Branch_Id >= 0)
            {
                where += string.Format(" AND a." + nameof(RB_ClientBankAccount.RB_Branch_Id) + "={0} ", model.RB_Branch_Id);
            }
            if (model.ID > 0)
            {
                where += string.Format(" AND a." + nameof(RB_ClientBankAccount.ID) + "={0} ", model.ID);
            }
            if (ClientIdStr != "")
            {
                where += string.Format(" AND a." + nameof(RB_ClientBankAccount.ID) + " in({0}) ", ClientIdStr);
            }
            if (model.Type > 0)
            {
                where += string.Format(" AND a." + nameof(RB_ClientBankAccount.Type) + "={0}", (int)model.Type);
            }
            if (model.ObjID > 0)
            {
                where += string.Format(" AND a." + nameof(RB_ClientBankAccount.ObjID) + "={0}", model.ObjID);
            }
            if (!string.IsNullOrEmpty(model.AccountAlias))
            {
                where += string.Format(" AND a." + nameof(RB_ClientBankAccount.AccountAlias) + "='{0}'", model.AccountAlias);
            }
            if (AccountAlias != "")
            {
                where += string.Format(" AND a." + nameof(RB_ClientBankAccount.AccountAlias) + " like'%{0}%'", AccountAlias);
            }
            if (!string.IsNullOrEmpty(model.CardNum))
            {
                where += string.Format(" AND a." + nameof(RB_ClientBankAccount.CardNum) + " like '%{0}%' ", model.CardNum);
            }
            string sql = $@"select a.* from {TableName} as a   {where}";
            return Get<RB_ClientBankAccount>(sql).ToList();
        }

        /// <summary>
        /// 根据查询条件获取客户账户列表
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public List<RB_ClientBankAccount> GetList(RB_ClientBankAccount_Extend model)
        {
            string where = " WHERE 1=1 ";
            where += string.Format(" AND a." + nameof(RB_ClientBankAccount.Status) + "={0} ", (int)DateStateEnum.Normal);
            if (model.RB_Group_Id > 0)
            {
                where += string.Format(" AND a." + nameof(RB_ClientBankAccount.RB_Group_Id) + "={0} ", model.RB_Group_Id);
            }
            if (model.RB_Branch_Id >= 0)
            {
                where += string.Format(" AND a." + nameof(RB_ClientBankAccount.RB_Branch_Id) + "={0} ", model.RB_Branch_Id);
            }
            if (model.ID > 0)
            {
                where += string.Format(" AND a." + nameof(RB_ClientBankAccount.ID) + "={0} ", model.ID);
            }
            if (!string.IsNullOrWhiteSpace(model.ClientIdStr))
            {
                where += string.Format(" AND a." + nameof(RB_ClientBankAccount.ID) + " in({0}) ", model.ClientIdStr);
            }
            if (model.Type > 0)
            {
                where += string.Format(" AND a." + nameof(RB_ClientBankAccount.Type) + "={0}", (int)model.Type);
            }
            if (model.ObjID > 0)
            {
                where += string.Format(" AND a." + nameof(RB_ClientBankAccount.ObjID) + "={0}", model.ObjID);
            }
            if (!string.IsNullOrWhiteSpace(model.ObjIdStr))
            {
                where += string.Format(" AND a." + nameof(RB_ClientBankAccount.ObjID) + " in({0})", model.ObjIdStr);
            }
            if (!string.IsNullOrEmpty(model.AccountAlias))
            {
                where += string.Format(" AND a." + nameof(RB_ClientBankAccount.AccountAlias) + "='{0}'", model.AccountAlias);
            }
            if (!string.IsNullOrEmpty(model.CardNum))
            {
                where += string.Format(" AND a." + nameof(RB_ClientBankAccount.CardNum) + " like '%{0}%' ", model.CardNum);
            }
            string sql = $@"select a.* from {TableName} as a   {where}";
            return Get<RB_ClientBankAccount>(sql).ToList();
        }

    }
}
