﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 推荐供应商返佣账单仓储层
    /// </summary>
    public class RB_Distributor_BillRepository : BaseRepository<RB_Distributor_Bill>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Distributor_Bill_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Distributor_Bill_Extend dmodel)
        {
            string where = $@" 1=1 and {nameof(RB_Distributor_Bill.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Distributor_Bill.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Distributor_Bill.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and {nameof(RB_Distributor_Bill.UserId)}={dmodel.UserId}";
            }
            if (dmodel.SupplierId > 0)
            {
                where += $@" and {nameof(RB_Distributor_Bill.SupplierId)}={dmodel.SupplierId}";
            }
            if (!string.IsNullOrEmpty(dmodel.Periods))
            {
                where += $@" and {nameof(RB_Distributor_Bill.Periods)} like '%{dmodel.Periods}%'";
            }
            if (dmodel.BillState > 0)
            {
                where += $@" and {nameof(RB_Distributor_Bill.BillState)}={dmodel.BillState}";
            }

            if (dmodel.SelectBillState > 0)
            {
                where += $@" and {nameof(RB_Distributor_Bill.BillState)}={dmodel.SelectBillState}";
            }
            else if (dmodel.SelectBillState == -1)
            {
                where += $@" and {nameof(RB_Distributor_Bill.BillState)} in(1,2)";
            }
            string sql = $@"select * from RB_Distributor_Bill where {where} order by Id desc";
            return GetPage<RB_Distributor_Bill_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Distributor_Bill_Extend> GetList(RB_Distributor_Bill_Extend dmodel)
        {
            string where = $@" 1=1 and {nameof(RB_Distributor_Bill.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Distributor_Bill.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Distributor_Bill.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and {nameof(RB_Distributor_Bill.UserId)}={dmodel.UserId}";
            }
            if (dmodel.SupplierId > 0)
            {
                where += $@" and {nameof(RB_Distributor_Bill.SupplierId)}={dmodel.SupplierId}";
            }
            if (!string.IsNullOrEmpty(dmodel.Periods))
            {
                where += $@" and {nameof(RB_Distributor_Bill.Periods)} like '%{dmodel.Periods}%'";
            }
            if (dmodel.BillState > 0)
            {
                where += $@" and {nameof(RB_Distributor_Bill.BillState)}={dmodel.BillState}";
            }
            if (dmodel.SelectBillState > 0)
            {
                where += $@" and {nameof(RB_Distributor_Bill.BillState)}={dmodel.SelectBillState}";
            }
            else if (dmodel.SelectBillState == -1)
            {
                where += $@" and {nameof(RB_Distributor_Bill.BillState)} in(1,2)";
            }
            string sql = $@"select * from RB_Distributor_Bill where {where} order by Id desc";
            return Get<RB_Distributor_Bill_Extend>(sql).ToList();
        }
    }
}
