﻿using VT.FW.DB;
using System;

namespace Mall.Model.Entity.Product
{
    /// <summary>
    /// 拼团活动商品关联会员价格表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Groupbuy_Memberprice
    {
        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 商品id
        /// </summary>        
        public int? GoodsId
        {
            get;
            set;
        }
        /// <summary>
        /// 规格排序组  逗号分隔每规格值
        /// </summary>        
        public string SpecificationSort
        {
            get;
            set;
        }
        /// <summary>
        /// 分销商等级   0普通等级
        /// </summary>        
        public int? MemberGrade
        {
            get;
            set;
        }
        /// <summary>
        /// 会员价格
        /// </summary>        
        public decimal? MemberPrice
        {
            get;
            set;
        }
        /// <summary>
        /// Status
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
    }
}