﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Configuration.Install;
using System.Data;
using System.Drawing;
using System.Linq;
using System.ServiceProcess;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Mall.EducationClient
{
    public partial class ClientServerControl : Form
    {
        public ClientServerControl()
        {
            InitializeComponent();
        }
        private static string serviceFilePath = $"{Application.StartupPath}\\Mall.Education.exe";
        private static string serviceName = "EducationToImageServer";


        private void SocketServerControl_Load(object sender, EventArgs e)
        {
            if (this.IsServiceExisted(serviceName))
            {
                this.btnInstallationServer.Enabled = false;
                this.btnUninstallServer.Enabled = true;
                if (ServiceStatus(serviceName) == ServiceControllerStatus.Running)
                {
                    this.btnStartServer.Enabled = false;
                    this.btnStopServer.Enabled = true;
                }
                else
                {
                    this.btnStartServer.Enabled = true;
                    this.btnStopServer.Enabled = false;
                }
            }
            else
            {
                this.btnInstallationServer.Enabled = true;
                this.btnStartServer.Enabled = false;
                this.btnStopServer.Enabled = false;
                this.btnUninstallServer.Enabled = false;
            }
        }

        private void btnInstallationServer_Click(object sender, EventArgs e)
        {
            if (!this.IsServiceExisted(serviceName))
            {
                this.InstallService(serviceFilePath);
            }
            this.btnInstallationServer.Enabled = false;
            this.btnStartServer.Enabled = true;
            this.btnStopServer.Enabled = false;
            this.btnUninstallServer.Enabled = true;

        }

        private void btnStartServer_Click(object sender, EventArgs e)
        {
            if (this.IsServiceExisted(serviceName))
            {
                if (ServiceStatus(serviceName) == ServiceControllerStatus.Running)
                {
                    this.ServiceStop(serviceName);
                }
                this.ServiceStart(serviceName);
                this.btnStartServer.Enabled = false;
                this.btnStopServer.Enabled = true;
            }
            else
            {
                MessageBox.Show("服务不存在");
            }
        }

        private void btnStopServer_Click(object sender, EventArgs e)
        {
            if (this.IsServiceExisted(serviceName))
            {
                this.ServiceStop(serviceName);
                this.btnStartServer.Enabled = true;
                this.btnStopServer.Enabled = false;
            }
            else
            {
                MessageBox.Show("服务不存在");
            }

        }

        private void btnUninstallServer_Click(object sender, EventArgs e)
        {
            if (this.IsServiceExisted(serviceName))
            {
                this.ServiceStop(serviceName);
                this.UninstallService(serviceFilePath);
                this.btnInstallationServer.Enabled = true;
                this.btnStartServer.Enabled = false;
                this.btnStopServer.Enabled = false;
                this.btnUninstallServer.Enabled = false;
            }
            else
            {
                MessageBox.Show("服务不存在");
            }

        }
        //判断服务是否存在
        private bool IsServiceExisted(string serviceName)
        {
            ServiceController[] services = ServiceController.GetServices();
            foreach (ServiceController sc in services)
            {
                if (sc.ServiceName.ToLower() == serviceName.ToLower())
                {
                    return true;
                }
            }
            return false;
        }
        //安装服务
        private void InstallService(string serviceFilePath)
        {
            using (AssemblyInstaller installer = new AssemblyInstaller())
            {
                installer.UseNewContext = true;
                installer.Path = serviceFilePath;
                IDictionary savedState = new Hashtable();
                installer.Install(savedState);
                installer.Commit(savedState);
            }
        }

        //卸载服务
        private void UninstallService(string serviceFilePath)
        {
            using (AssemblyInstaller installer = new AssemblyInstaller())
            {
                installer.UseNewContext = true;
                installer.Path = serviceFilePath;
                installer.Uninstall(null);
            }
        }
        //启动服务
        private void ServiceStart(string serviceName)
        {
            using (ServiceController control = new ServiceController(serviceName))
            {
                if (control.Status == ServiceControllerStatus.Stopped)
                {
                    control.Start();
                }
            }
        }

        //停止服务
        private void ServiceStop(string serviceName)
        {
            using (ServiceController control = new ServiceController(serviceName))
            {
                if (control.Status == ServiceControllerStatus.Running)
                {
                    control.Stop();
                }
            }
        }

        //获取服务状态
        private ServiceControllerStatus ServiceStatus(string serviceName)
        {
            using (ServiceController control = new ServiceController(serviceName))
            {
                return control.Status;
            }
        }

    }
}
