﻿using Mall.Common.Enum;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品留言表仓储层
    /// </summary>
    public class RB_Goods_LeavemessageRepository:BaseRepository<RB_Goods_Leavemessage>
    {
        /// <summary>
        /// 获取商品留言分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Goods_Leavemessage_Extend> GetGoodsLeavemessagePageRepository(int pageIndex, int pageSize, out long rowsCount, RB_Goods_Leavemessage_Extend query)
        {
            rowsCount = 0;
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*
FROM RB_Goods_Leavemessage AS A 
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Goods_Leavemessage_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_Goods_Leavemessage_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Goods_Leavemessage_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Goods_Leavemessage_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.Content))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @Name ", nameof(RB_Goods_Leavemessage_Extend.Content));
                    parameters.Add("Name", "%" + query.Content.Trim() + "%");
                }
                if (query.GoodsId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Goods_Leavemessage_Extend.GoodsId), query.GoodsId);
                }
            }
            return GetPage<RB_Goods_Leavemessage_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }

    }
}
