﻿using Mall.Common.Enum;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Mall.Repository.User
{
    /// <summary>
    /// 用户分组仓储层
    /// </summary>
    public class RB_Member_GroupRepository : BaseRepository<RB_Member_Group>
    {
        /// <summary>
        /// 获取用户分组分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Member_Group_Extend> GetMemberGroupPageRepository(int pageIndex, int pageSize, out long rowsCount, RB_Member_Group_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.* 
FROM RB_Member_Group AS A
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Member_Group_Extend.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Member_Group_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Member_Group_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.GroupName))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @GroupName ", nameof(RB_Member_Group_Extend.GroupName));
                    parameters.Add("GroupName", "%" + query.GroupName.Trim() + "%");
                }
            }
            builder.AppendFormat(" ORDER BY A.{0} DESC ", nameof(RB_Member_Group_Extend.GroupId));
            return GetPage<RB_Member_Group_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 获取用户分组列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Member_Group_Extend> GetMemberGroupListRepository(RB_Member_Group_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.* 
FROM RB_Member_Group AS A
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Member_Group_Extend.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Member_Group_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Member_Group_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.GroupName))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @GroupName ", nameof(RB_Member_Group_Extend.GroupName));
                    parameters.Add("GroupName", "%" + query.GroupName.Trim() + "%");
                }
                if (!string.IsNullOrEmpty(query.Q_GroupIds))
                {
                    builder.AppendFormat(" AND A.{0} IN({1}) ", nameof(RB_Member_Group_Extend.GroupId), query.Q_GroupIds);
                }
                if (query.IsQueryDefault == 1)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Member_Group_Extend.IsDefault), 1);
                }
            }
            return Get<RB_Member_Group_Extend>(builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 修改默认分组
        /// </summary>
        /// <param name="MallBaseId"></param>
        /// <returns></returns>
        public bool UpdateIsDefaultRepository(int MallBaseId)
        {
            string sql = string.Format(" UPDATE RB_Member_Group SET IsDefault=0 WHERE MallBaseId={0} ", MallBaseId);
            return base.Execute(sql)>0;
        }
    }
}
