﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common.Enum;
using Mall.Model.Entity.Finance;
using Mall.Model.Extend.Finance;

namespace Mall.Repository.Finance
{
    /// <summary>
    /// 资金池账户仓储层
    /// </summary>
    public class RB_CashPoolAccountRepository : BaseRepository<RB_CashPoolAccount>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_CashPoolAccount); } }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public List<RB_CashPoolAccount_Extend> GetList(RB_CashPoolAccount_Extend model)
        {
            string where = " WHERE 1=1 ";
            where += string.Format(" AND " + nameof(RB_CashPoolAccount_Extend.Status) + "={0} ", (int)DateStateEnum.Normal);
            if (model.RB_Group_Id > 0)
            {
                where += string.Format(" AND " + nameof(RB_CashPoolAccount_Extend.RB_Group_Id) + "={0} ", model.RB_Group_Id);
            }
            if (!string.IsNullOrWhiteSpace(model.AccountIdStr))
            {
                where += string.Format(" AND " + nameof(RB_CashPoolAccount_Extend.ID) + " in({0}) ", model.AccountIdStr);
            }
            if (model.TypeId >= 0)
            {
                where += string.Format(" AND " + nameof(RB_CashPoolAccount_Extend.TypeId) + "={0} ", model.TypeId);
            }
            if (!string.IsNullOrWhiteSpace(model.TypeIdStr))
            {
                where += string.Format(" AND " + nameof(RB_CashPoolAccount_Extend.TypeId) + " in({0}) ", model.TypeIdStr);
            }
            if (model.CurrencyId > 0)
            {
                where += string.Format(" AND " + nameof(RB_CashPoolAccount_Extend.CurrencyId) + "={0} ", model.CurrencyId);
            }
            if (!string.IsNullOrWhiteSpace(model.Alias))
            {
                where += string.Format(" AND " + nameof(RB_CashPoolAccount_Extend.Alias) + " like'%{0}%' ", model.Alias);
            }
            return Get<RB_CashPoolAccount_Extend>("select * from " + TableName + " " + where).ToList();
        }
    }
}
