﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Mall.Common.Plugin;
namespace Mall.Common.API.Model
{
    /// <summary>
    /// 动态表单数据
    /// </summary>
    public class AuditInfoModel
    {
        /// <summary>
        /// 表单名
        /// </summary>
        public string title { get; set; }

        /// <summary>
        /// 表单值
        /// </summary>
        public object value { get; set; }

        /// <summary>
        /// 表单类型
        /// </summary>
        public string formType { get; set; }
    }
    /// <summary>
    /// 详情类型枚举
    /// </summary>
    public enum AuditInfoTypeEnum
    {
        /// <summary>
        /// string类型数据
        /// </summary>
        [EnumField("String")]
        String = 1,
        /// <summary>
        /// json格式数据
        /// </summary>
        [EnumField("Json")]
        Json = 2,
        /// <summary>
        /// Image格式数据
        /// </summary>
        [EnumField("Image")]
        Image = 3
    }
}
