﻿using Mall.Common.AOP;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Property
{

    /// <summary>
    /// 商品出库申请实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "PropertyConnection")]
    public class RB_WarehouseOut_Apply
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int ID
        {
            get;
            set;
        }


        /// <summary>
        /// 出库单号
        /// </summary>
        public string OutNo { get; set; }
        /// <summary>
        /// 删除状态0-否，1-是
        /// </summary>        
        public int Status
        {
            get;
            set;
        }
        /// <summary>
        /// 申请状态1-审核中,2-通过，3-拒绝
        /// </summary>        
        public int ApplyStatus
        {
            get;
            set;
        }

        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }

        /// <summary>
        /// 供应商id
        /// </summary>
        public int SupplierId
        {
            get;
            set;
        }
        /// <summary>
        /// 公司
        /// </summary>        
        public int? RB_Branch_Id
        {
            get;
            set;
        }
        /// <summary>
        /// 集团
        /// </summary>        
        public int? RB_Group_Id
        {
            get;
            set;
        }

        /// <summary>
        /// 出库状态  0-未出库，1-部分出库，2-全部出库
        /// </summary>
        public int OutStatus { get; set; }

        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }

        /// <summary>
        /// erp操作人的id
        /// </summary>        
        public int? CreateBy
        {
            get;
            set;
        }

        /// <summary>
        /// 电商操作人id
        /// </summary>        
        public int? MallUserId
        {
            get;
            set;
        }
        /// <summary>
        /// erp操作人的id
        /// </summary>        
        public int? UpdateBy
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }


        /// <summary>
        /// 审核理由
        /// </summary>
        public string ExamineReason { get; set; }


    }
}
