﻿using Mall.Model.Entity.Property;
using Mall.Model.Extend.Property;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Property
{
    /// <summary>
    /// 耗材入库单明细仓储类
    /// </summary>
    public partial class RB_Supplies_StockInDetailRepository : RepositoryBase<RB_Supplies_StockInDetail>
    {
        /// <summary>
        /// 获取入库明细数据
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Supplies_StockInDetail_Extend> GetList(RB_Supplies_StockInDetail_Extend dmodel)
        {
            string where = " where 1=1 ";
            where += string.Format(" AND ssd.{0}={1}", nameof(RB_Supplies_StockInDetail_Extend.Status), 0);
            where += $@" and ssd.RB_Group_Id={dmodel.RB_Group_Id}";            

            if (dmodel.StockInId > 0) {
                where += " and ssd." + nameof(RB_Supplies_StockInDetail_Extend.StockInId) + "=" + dmodel.StockInId;
            }
            if (!string.IsNullOrEmpty(dmodel.StockInIdStr)) {
                where += " and ssd." + nameof(RB_Supplies_StockInDetail_Extend.StockInId) + " in(" + dmodel.StockInIdStr + ")";
            }
            
            string sql = $@" select ssd.*,sm.Name as SuppliesName,sm.SuppliesNum,sm.BrandName,sm.SuppliesModel,sm.Units,pc.Name as CategoryName
from rb_supplies_stockindetail ssd 
left join rb_supplies_material sm on ssd.SuppliesId=sm.Id
left join rb_property_category pc on pc.Id=sm.CategoryId
{where} order by ssd.Id desc";
            return Get<RB_Supplies_StockInDetail_Extend>(sql).ToList();
        }        
    }
}
