﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 专题分类表仓储层
    /// </summary>
    public class RB_Topic_TypeRepository : RepositoryBase<RB_Topic_Type>
    {
        /// <summary>
        /// 专题分类分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Topic_Type_Extend> GetTopicTypePageListRepository(int pageIndex, int pageSize, out long rowCount, RB_Topic_Type_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@" SELECT * FROM RB_Topic_Type WHERE 1=1 AND Status=0 ");
            if (query.TenantId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Topic_Type_Extend.TenantId), query.TenantId);
            }
            if (query.MallBaseId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Topic_Type_Extend.MallBaseId), query.MallBaseId);
            }
            if (query.Id > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Topic_Type_Extend.Id), query.Id);
            }
            if (query.TopicName != null && !string.IsNullOrEmpty(query.TopicName.Trim()))
            {
                builder.AppendFormat(" AND {0} LIKE '%{1}%' ", nameof(RB_Topic_Type_Extend.TopicName), query.TopicName.Trim());
            }
            builder.Append(" ORDER BY SortNum ");
            return GetPage<RB_Topic_Type_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }

        /// <summary>
        /// 获取专题分类列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Topic_Type_Extend> GetTopicTypeListRepository(RB_Topic_Type_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@" SELECT * FROM RB_Topic_Type WHERE 1=1 AND Status=0 ");
            if (query.TenantId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Topic_Type_Extend.TenantId), query.TenantId);
            }
            if (query.MallBaseId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Topic_Type_Extend.MallBaseId), query.MallBaseId);
            }
            if (query.Id > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Topic_Type_Extend.Id), query.Id);
            }
            if (query.TopicName != null && !string.IsNullOrEmpty(query.TopicName.Trim()))
            {
                builder.AppendFormat(" AND {0} LIKE '%{1}%' ", nameof(RB_Topic_Type_Extend.TopicName), query.TopicName.Trim());
            }
            builder.Append(" ORDER BY SortNum ");
            return Get<RB_Topic_Type_Extend>(builder.ToString()).ToList();
        }
    }
}
