﻿using Mall.Common.AOP;
using Mall.Common.Enum.Goods;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Product
{
    /// <summary>
    /// 商品订单售后表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_OrderAfterSale
    {

        /// <summary>
        /// ReOrderId
        /// </summary>        
        public int ReOrderId
        {
            get;
            set;
        }
        /// <summary>
        /// 用户id
        /// </summary>        
        public int? UserId
        {
            get;
            set;
        }
        /// <summary>
        /// 订单id
        /// </summary>        
        public int? OrderId
        {
            get;
            set;
        }
        /// <summary>
        /// 订单明细id
        /// </summary>        
        public int? OrderDetialId
        {
            get;
            set;
        }
        /// <summary>
        /// 售后订单号
        /// </summary>        
        public string ReOrderNo
        {
            get;
            set;
        }
        /// <summary>
        /// 类型  1退货退款   2换货
        /// </summary>        
        public int? Type
        {
            get;
            set;
        }
        /// <summary>
        /// 原因
        /// </summary>        
        public string Remark
        {
            get;
            set;
        }
        /// <summary>
        /// 退货数量
        /// </summary>
        public int? ReNumber { get; set; }
        /// <summary>
        /// 客人付款金额
        /// </summary>
        public decimal? Income { get; set; }
        /// <summary>
        /// 退款金额
        /// </summary>        
        public decimal? Refund
        {
            get;
            set;
        }
        /// <summary>
        /// 实际退款金额
        /// </summary>
        public decimal? RefundActual { get; set; }
        /// <summary>
        /// 凭证图片  json格式
        /// </summary>        
        public string Voucher
        {
            get;
            set;
        }
        /// <summary>
        /// 售后状态  1待审核  2待买家发货  3已发货待商家处理（待卖家收货） 4待卖家退款  5已完成  6已拒绝
        /// </summary>        
        public OrderAfterSaleStatusEnum? ReOrderStatus
        {
            get;
            set;
        }
        /// <summary>
        /// 商家收货地址id
        /// </summary>        
        public int? DeliveryId
        {
            get;
            set;
        }
        /// <summary>
        /// 客人退货物流id
        /// </summary>        
        public int? ReExpressId
        {
            get;
            set;
        }
        /// <summary>
        /// 客人退货快递单号
        /// </summary>        
        public string ReExpressNumber
        {
            get;
            set;
        }
        /// <summary>
        /// 同意/拒绝时间
        /// </summary>        
        public DateTime? AuditTime
        {
            get;
            set;
        }
        /// <summary>
        /// 完成时间
        /// </summary>        
        public DateTime? FinishTime
        {
            get;
            set;
        }
        /// <summary>
        /// 删除状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 商家备注
        /// </summary>
        public string ReRemark { get; set; }
        /// <summary>
        /// 财务单据id
        /// </summary>
        public int? FinanceId { get; set; }
    }
}
