﻿using Mall.Model.Entity.GuideCar;
using Mall.Model.Extend.GuideCar;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.GuideCar
{
    /// <summary>
    /// 司导-车辆仓储层
    /// </summary>
    public class RB_GuideCar_CarRepository : BaseRepository<RB_GuideCar_Car>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_GuideCar_Car); } }
        /// <summary>
        /// 司导-车辆列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_GuideCar_Car_Extend> GetPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_GuideCar_Car_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE  {nameof(RB_GuideCar_Car_Extend.Status)}=0");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_GuideCar_Car_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_GuideCar_Car_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND {nameof(RB_GuideCar_Car_Extend.Name)} like '%{query.Name}%'");
                }
                if (!string.IsNullOrWhiteSpace(query.CarBrand))
                {
                    builder.Append($" AND {nameof(RB_GuideCar_Car_Extend.CarBrand)} like '%{query.CarBrand}%'");
                }
                if (query.CarClass > 0)
                {
                    builder.Append($" AND {nameof(RB_GuideCar_Car_Extend.CarClass)}={(int)query.CarClass}");
                }
            }
            return GetPage<RB_GuideCar_Car_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 司导-车辆列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_GuideCar_Car_Extend> GetGuideCarCarList(RB_GuideCar_Car_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_GuideCar_Car_Extend.Status)}=0 ");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND {nameof(RB_GuideCar_Car_Extend.ID)}={query.ID}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_GuideCar_Car_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_GuideCar_Car_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND {nameof(RB_GuideCar_Car_Extend.Name)} like '%{query.Name}%'");
                }
                if (!string.IsNullOrWhiteSpace(query.CarBrand))
                {
                    builder.Append($" AND {nameof(RB_GuideCar_Car_Extend.CarBrand)} like '%{query.CarBrand}%'");
                }
                if (query.CarClass > 0)
                {
                    builder.Append($" AND {nameof(RB_GuideCar_Car_Extend.CarClass)}={(int)query.CarClass}");
                }
            }
            return Get<RB_GuideCar_Car_Extend>(builder.ToString()).ToList();
        }
    }
}
