﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Extend.Point;
using Mall.Repository.Point;
using Mall.Repository.User;
using VT.FW.DB;

namespace Mall.Module.Education
{
    public class PointModule
    {
        /// <summary>
        /// 点数产品仓储
        /// </summary>
        private readonly RB_Point_GoodsRepository pointGoodsRepository = new RB_Point_GoodsRepository();
        private readonly RB_Point_OrderRepository pointOrderRepository = new RB_Point_OrderRepository();
        private readonly RB_Member_PointBalanceRepository memberPointBalanceRepository = new RB_Member_PointBalanceRepository();
        /// <summary>
        /// 会员信息
        /// </summary>
        private readonly RB_Member_UserRepository member_UserRepository = new RB_Member_UserRepository();
        #region 点数商品
        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_Goods_Extend> GetPointGoodsList(RB_Point_Goods_Extend where)
        {
            return pointGoodsRepository.GetPointGoodsList(where);
        }



        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_Goods_Extend> GetPointGoodsPageList(int pageIndex, int pageSize, out long rowsCount, RB_Point_Goods_Extend where)
        {

            return pointGoodsRepository.GetPointGoodsPageList(pageIndex, pageSize, out rowsCount, where);
        }


        /// <summary>
        /// 新增/修改点数商品
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetPointGoods(RB_Point_Goods_Extend model)
        {
            if (model.ID == 0)
            {
                return pointGoodsRepository.Insert(model) > 0;
            }
            else
            {
                IDictionary<string, object> fileds = new Dictionary<string, object>
                {
                    { nameof(RB_Point_Goods_Extend.UpdateDate), model.UpdateDate },
                    { nameof(RB_Point_Goods_Extend.GoodsName), model.GoodsName },
                    { nameof(RB_Point_Goods_Extend.GivePonit), model.GivePonit },
                    { nameof(RB_Point_Goods_Extend.OriginalPrice), model.OriginalPrice },
                    { nameof(RB_Point_Goods_Extend.SellingPrice), model.SellingPrice },
                    { nameof(RB_Point_Goods_Extend.Sort), model.Sort },
                    { nameof(RB_Point_Goods_Extend.CostPrice), model.CostPrice },
                    { nameof(RB_Point_Goods_Extend.PonitNum), model.PonitNum }
                };
                IList<WhereHelper> auditrecordWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_Goods_Extend.ID),
                            FiledValue = model.ID,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_Goods_Extend.TenantId),
                            FiledValue = model.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_Goods_Extend.MallBaseId),
                            FiledValue = model.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };
                return pointGoodsRepository.Update(fileds, auditrecordWhereHelpers);
            }
        }


        /// <summary>
        /// 删除点数商品
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool DeletePointGoods(RB_Point_Goods_Extend model)
        {
            IDictionary<string, object> fileds = new Dictionary<string, object>
                {
                    { nameof(RB_Point_Goods_Extend.UpdateDate), model.UpdateDate },
                    { nameof(RB_Point_Goods_Extend.State),1 }
                };
            IList<WhereHelper> auditrecordWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_Goods_Extend.ID),
                            FiledValue = model.ID,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_Goods_Extend.TenantId),
                            FiledValue = model.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_Goods_Extend.MallBaseId),
                            FiledValue = model.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };
            return pointGoodsRepository.Update(fileds, auditrecordWhereHelpers);

        }

        #endregion

        #region 充值订单
        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_Order_Extend> GetPointOrderList(RB_Point_Order_Extend where)
        {
            return pointOrderRepository.GetPointOrderList(where);
        }



        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_Order_Extend> GetPointGoodsPageList(int pageIndex, int pageSize, out long rowsCount, RB_Point_Order_Extend where)
        {

            return pointOrderRepository.GetPointOrderPageList(pageIndex, pageSize, out rowsCount, where);
        }

        /// <summary>
        /// 新增/修改点数订单
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool UpdatePointOrder(RB_Point_Order_Extend newModel)
        {
            var umodel = member_UserRepository.GetEntity(newModel.UserId);
            if (umodel == null)
            {
                return false;
            }
            //判断订单状态是否是待支付  2020-06-16 Add By:W
            var model = pointOrderRepository.GetEntity(newModel.ID);
            if (model == null)
            {
                return false;
            }
            if (model.State != 0)
            {
                return false;
            }
            if (model.Income != newModel.Income)
            {
                return false;
            }
            var trans = pointOrderRepository.DbTransaction;
            bool flag;
            if (model.ID > 0)
            {

                IDictionary<string, object> fileds = new Dictionary<string, object>
                {
                    { nameof(RB_Point_Order_Extend.PaymentTime), newModel.PaymentTime },
                    { nameof(RB_Point_Order_Extend.OrderStatus), newModel.OrderStatus },
                    { nameof(RB_Point_Order_Extend.MerchantsNo), newModel.MerchantsNo },
                    { nameof(RB_Point_Order_Extend.OldPonitNum), newModel.OldPonitNum }
                };
                IList<WhereHelper> auditrecordWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_Order_Extend.ID),
                            FiledValue = model.ID,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_Order_Extend.TenantId),
                            FiledValue = model.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_Order_Extend.MallBaseId),
                            FiledValue = model.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };

                RB_Member_PointBalance_Extend memberBalanceModel = new RB_Member_PointBalance_Extend
                {
                    UserId = model.UserId,
                    Type = Common.Enum.MarketingCenter.RecordTypeEnum.Income,
                    PonitNum = newModel.PonitNum + newModel.GivePoint,
                    Description = "在线购买" + model.PonitNum + "点" + (model.GivePoint > 0 ? ("赠送" + model.GivePoint) : ""),
                    CreateDate = newModel.PaymentTime,
                    TenantId = model.TenantId,
                    MallBaseId = model.MallBaseId,
                    Remarks = "订单号：" + model.OrderNo + "在线购买支付" + model.Income + "元" + model.PonitNum + "点" + (model.GivePoint > 0 ? ("赠送" + model.GivePoint) : ""),
                    PlatformType = model.OrderSource
                };
                memberPointBalanceRepository.Insert(memberBalanceModel, trans);

                flag = pointOrderRepository.Update(fileds, auditrecordWhereHelpers, trans);
                if (flag)
                {
                    IDictionary<string, object> filedsUser = new Dictionary<string, object>
                {
                    { nameof(Model.Entity.User.RB_Member_User.PointNum), umodel.PointNum+model.PonitNum+model.GivePoint }
                };
                    IList<WhereHelper> userWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(Model.Entity.User.RB_Member_User.Id),
                            FiledValue = umodel.Id,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(Model.Entity.User.RB_Member_User.TenantId),
                            FiledValue = umodel.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(Model.Entity.User.RB_Member_User.MallBaseId),
                            FiledValue = umodel.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };

                }
                return flag;
            }
            else
            {
                return false;
            }
        }



        /// <summary>
        /// 新增/修改点数订单
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int SetPointOrder(RB_Point_Order_Extend model)
        {
            if (model.ID == 0)
            {
                return pointOrderRepository.Insert(model);
            }
            return 0;
        }



        #endregion

        #region 点数明细
        /// <summary>
        /// 获取点数明细
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Member_PointBalance_Extend> GetUserPointDetailPageList(int pageIndex, int pageSize, out long count, RB_Member_PointBalance_Extend demodel)
        {
            return memberPointBalanceRepository.GetPointBalancePageList(pageIndex, pageSize, out count, demodel);
        }

        /// <summary>
        /// 获取用户点数
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        public int GetUserPointBalance(int userId) {
            return member_UserRepository.GetEntity(userId)?.PointNum ?? 0;
        }

        #endregion
    }
}
