﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Extend.Point;
using Mall.Module.Education;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace Mall.WebApi.Controllers.Education
{

    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class PointController : BaseController
    {

        private readonly PointModule pointModule = new PointModule();

        #region 点数商品
        [HttpPost]
        public ApiResult GetPointGoodsPageList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            RB_Point_Goods_Extend demodel = JsonConvert.DeserializeObject<RB_Point_Goods_Extend>(RequestParm.msg.ToString());
            demodel.TenantId = UserInfo.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            //demodel.TeacherStatus = -1;
            var list = pointModule.GetPointGoodsPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.ID,
                x.GivePoint,
                x.GoodsName,
                x.PonitNum,
                x.SellingPrice,
                IsGive = (x.GivePoint > 0) ? 1 : 0
            });
            return ApiResult.Success("", pagelist);
        }


        /// <summary>
        /// 获取详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetPointGoodsModel()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Point_Goods_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var oldPointGoodsModel = pointModule.GetPointGoodsList(query).FirstOrDefault();
            if (oldPointGoodsModel == null)
            {
                oldPointGoodsModel = new RB_Point_Goods_Extend();
            }
            return ApiResult.Success("", oldPointGoodsModel);
        }


        /// <summary>
        /// 保存点数产品信息
        /// </summary>
        /// <returns></returns>
        public ApiResult SetPointGoods()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Point_Goods_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            if (query == null)
            {
                return ApiResult.Failed("请传入点数产品信息");
            }
            else
            {
                if (string.IsNullOrWhiteSpace(query.GoodsName))
                {
                    return ApiResult.Failed("请输入产品名称");
                }
                if (query.PonitNum == 0)
                {
                    return ApiResult.Failed("请输入点数");
                }
                if (query.SellingPrice == 0)
                {
                    return ApiResult.Failed("请输入价格");
                }
                if (query.ID == 0)
                {
                    query.CreateDate = System.DateTime.Now;

                }
                query.OriginalPrice = 0;
                query.CostPrice = 0;
                query.Sort = 0;
                query.State = 0;
                query.UpdateDate = System.DateTime.Now;
                bool result = pointModule.SetPointGoods(query);
                if (result)
                {
                    return ApiResult.Success("点数产品信息保存成功");
                }
                else
                {
                    return ApiResult.Failed("点数产品信息保存失败");
                }
            }
        }



        /// <summary>
        /// 删除点数产品
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult DeletePointGoods()
        {
            var parms = RequestParm;
            JObject parmsJob = JObject.Parse(RequestParm.msg.ToString());
            int Id = parmsJob.GetInt("Id", 0);

            if (Id == 0)
            {
                return ApiResult.Failed("请选择您要删除的点数信息");
            }
            bool flag = pointModule.DeletePointGoods(new RB_Point_Goods_Extend { ID = Id, TenantId = UserInfo.TenantId, MallBaseId = parms.MallBaseId });
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        #endregion


        #region 个人中心-点数记录

        /// <summary>
        /// 获取点数记录
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetUserPointDetailPageList() {
            var parms = RequestParm;
            var userInfo = AppletUserInfo;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            RB_Member_PointBalance_Extend demodel = JsonConvert.DeserializeObject<RB_Member_PointBalance_Extend>(RequestParm.msg.ToString());
            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            var list = pointModule.GetUserPointDetailPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            int PointNum = pointModule.GetUserPointBalance(userInfo.UserId);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = new { 
                PointNum,
                List = list.Select(x => new
                {
                    x.Id,
                    x.Type,
                    TypeName = x.Type.GetEnumName(),
                    x.Description,
                    x.PonitNum,
                    x.CreateDate,
                    x.Remarks
                })
            };
            return ApiResult.Success("", pagelist);
        }

        #endregion
    }
}
