﻿using Mall.Common.AOP;
using Mall.Common.Enum.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.MarketingCenter
{
    /// <summary>
    /// 卡券实体表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Coupon
    {

        public int ID { get; set; }

        /// <summary>
        /// 商户id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }


        public int Status { get; set; }

        public DateTime CreateDate { get; set; }
        public DateTime UpdateDate { get; set; }
        public string Name { get; set; }

        public string CouponIco { get; set; }

        /// <summary>
        /// 有效期类型，1-领取后N天内有效，2-时间段
        /// </summary>
        public IndateTypeEnum IndateType { get; set; }


        /// <summary>
        /// 有效天数
        /// </summary>
        public int IndateDay { get; set; }

        /// <summary>
        /// 总核销次数
        /// </summary>
        public int HeXiao { get; set; }

        /// <summary>
        /// 可发放数量,-1 无限制
        /// </summary>
        public int TotalNum { get; set; }

        /// <summary>
        /// 描述
        /// </summary>
        public string Describe { get; set; }


        /// <summary>
        /// 领取数量
        /// </summary>
        public int ReceiveNum { get; set; }

        /// <summary>
        /// 有效期开始时间
        /// </summary>
        public DateTime? StartDate { get; set; }

        /// <summary>
        /// 有效期结束时间
        /// </summary>
        public DateTime? EndDate { get; set; }
    }
}
