﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Product
{
    /// <summary>
    ///不可开发票商品记录详情表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Invoice_RecordDetail
    {

        /// <summary>
        /// 编号
        /// </summary>
        public int ID { get; set; }



        /// <summary>
        /// 类型  1收款  2成本  3退款   4打款
        /// </summary>        
        public int? Type
        {
            get;
            set;
        }


        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }



        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }


        /// <summary>
        /// 商品名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 订单id
        /// </summary>
        public int OrderId { get; set; }

        /// <summary>
        /// 订单详情id
        /// </summary>
        public int OrderDetailId { get; set; }

        /// <summary>
        /// 商品价格
        /// </summary>
        public decimal GoodsPrice { get; set; }


        /// <summary>
        /// 单价
        /// </summary>        
        public decimal? Unit_Price
        {
            get;
            set;
        }
        /// <summary>
        /// 数量
        /// </summary>        
        public int? Number
        {
            get;
            set;
        }


        /// <summary>
        /// 运费
        /// </summary>
        public decimal FreightMoney { get; set; }

    }
}
