﻿using Mall.Common.Enum;
using System;
using VT.FW.DB;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 用户分组实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Member_Group
    {
        /// <summary>
        /// 分组编号(主键)
        /// </summary>
        public int GroupId { get; set; }

        /// <summary>
        /// 可查看分组编号
        /// </summary>
        public string LookGroupIds { get; set; }

        /// <summary>
        /// 分组名称
        /// </summary>
        public string GroupName { get; set; }

        /// <summary>
        /// 是否默认分组(1-是)
        /// </summary>
        public int IsDefault { get; set; }

        /// <summary>
        /// 商户号id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public DateStateEnum Status { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateDate { get; set; }

        /// <summary>
        /// 修改人
        /// </summary>
        public int UpdateBy { get; set; }

        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime UpdateDate { get; set; }
    }
}
