﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Education;
using VT.FW.DB;

namespace Mall.Model.Extend.Education
{
    /// <summary>
    /// 活动表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Education_Activity_Extend : RB_Education_Activity
    {
        /// <summary>
        /// 用户名称
        /// </summary>
        public string UserName { get; set; }

        /// <summary>
        /// 头像
        /// </summary>
        public string Photo { get; set; }

        /// <summary>
        /// 性别  1男  2女
        /// </summary>
        public int Sex { get; set; }

        /// <summary>
        /// 图片列表
        /// </summary>
        public List<string> ImageList { get; set; }

        /// <summary>
        /// 回复数量
        /// </summary>
        public int ReplyNum { get; set; }

        /// <summary>
        /// 报名数量
        /// </summary>
        public int EnrollNum { get; set; }

        /// <summary>
        /// 活动名称
        /// </summary>
        public string ActivityTypeName { get; set; }

        /// <summary>
        /// 活动ids
        /// </summary>
        public string ActivityIds { get; set; }

        /// <summary>
        /// 开始时间字符串
        /// </summary>
        public string StartTimeStr { get { return Common.ConvertHelper.FormatTime(this.StartTime); } }


        /// <summary>
        /// 结束时间字符串
        /// </summary>
        public string EndTimeStr { get { return Common.ConvertHelper.FormatTime(this.EndTime); } }


        /// <summary>
        /// 商会活动详情列表
        /// </summary>
       // public List<RB_Commerce_Details_Extend> CommerceDetailsList { get; set; }

        /// <summary>
        /// 报名列表
        /// </summary>
        public List<RB_Education_Consult_Extend> EducationConsultList { get; set; }

        /// <summary>
        /// 活动状态
        /// </summary>
        public int ActivityStatus
        {
            get
            {
                int status = 0;//未开始
                DateTime currentDay = Convert.ToDateTime(Common.ConvertHelper.FormatTime(DateTime.Now));
                if (currentDay >= this.StartTime && currentDay <= this.EndTime)
                {
                    status = 1;//进行中
                }
                else if (currentDay > this.EndTime)
                {
                    status = 2;//已结束
                }
                return status;
            }
        }

        /// <summary>
        /// 是否可报名
        /// </summary>
        public int IsSignUp
        {
            get
            {
                int isSign = 0;
                if (this.SignStartTime != null && this.SignEndTime != null)
                {
                    DateTime currentDay = Convert.ToDateTime(Common.ConvertHelper.FormatTime(DateTime.Now));
                    if (currentDay >= this.SignStartTime && currentDay <= this.SignEndTime)
                    {
                        isSign = 1;//可报名
                    }
                }
                return isSign;
            }
        }

        /// <summary>
        /// 报名开始时间
        /// </summary>
        public string SignStartTimeStr { get { return Common.ConvertHelper.FormatTime(this.SignStartTime); } }

        /// <summary>
        /// 报名截止时间
        /// </summary>
        public string SignEndTimeStr { get { return Common.ConvertHelper.FormatTime(this.SignEndTime); } }

        /// <summary>
        /// 活动状态字符串
        /// </summary>
        public string ActivityStatusStr
        {
            get
            {
                string str = "未开始";
                switch (this.ActivityStatus)
                {
                    case 0:
                        str = "未开始";
                        break;
                    case 1:
                        str = "进行中";
                        break;
                    case 2:
                        str = "已结束";
                        break;
                }
                return str;
            }
        }

        /// <summary>
        /// 报名人数
        /// </summary>
        public int JoinNum { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public string CreateByName { get; set; }

        /// <summary>
        /// 是否报名(0-未报名，1-已报名)
        /// </summary>
        public int IsJoinActivity { get; set; }



        #region 查询时间字段
        /// <summary>
        /// 报名开始时间
        /// </summary>
        public string SelectStartTimeStr { get; set; }

        /// <summary>
        /// 报名截止时间
        /// </summary>
        public string SelectEndTimeStr { get; set; }

        public string OrderByStr { get; set; }

        /// <summary>
        /// 0-（小程序是即将开始，后台是未开始），1-已结束,1-进行中
        /// </summary>
        public int SelectIsEnd { get; set; }
        #endregion


        /// <summary>
        /// 活动安排  2021-06-25 Add By:W
        /// </summary>
        public List<RB_Education_ActivityTitle_Extend> ActivityTitleList { get; set; }

        /// <summary>
        /// 教育erp学生id
        /// </summary>
        public int EduStudentId { get; set; }

        /// <summary>
        /// 是否查询有封面图的活动
        /// </summary>
        public string IsQueryCoverImage { get; set; }
    }
}
