﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common.Enum;
using Mall.Model.Entity.Coffee;
using Mall.Model.Extend.Coffee;

namespace Mall.Repository.Coffee
{
    public class RB_Member_CoffeeLogRepository : BaseRepository<RB_Member_CoffeeLog>
    {
        /// <summary>
        /// 获取咖啡劵列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Member_CoffeeLog_Extend> GetPageList(int pageIndex,int pageSize, out long count,RB_Member_CoffeeLog_Extend query)
        {

            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_Member_CoffeeLog
WHERE 1=1
");
            if (query != null)
            {
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Member_CoffeeLog_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.UserId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Member_CoffeeLog_Extend.UserId), query.UserId);
                }
                if (query.Type > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Member_CoffeeLog_Extend.Type), query.Type);
                }
            }
            builder.AppendFormat(" order by Id desc");
            return GetPage<RB_Member_CoffeeLog_Extend>(pageIndex, pageSize, out count, builder.ToString()).ToList();
        }

        /// <summary>
        /// 获取咖啡劵列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Member_CoffeeLog_Extend> GetList(RB_Member_CoffeeLog_Extend query)
        {

            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_Member_CoffeeLog
WHERE 1=1
");
            if (query == null)
            {
                return new List<RB_Member_CoffeeLog_Extend>();
            }
            else
            {
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Member_CoffeeLog_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.UserId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Member_CoffeeLog_Extend.UserId), query.UserId);
                }
                if (query.Type > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Member_CoffeeLog_Extend.Type), query.Type);
                }
                if (!string.IsNullOrEmpty(query.Code))
                {
                    builder.AppendFormat(" AND {0}='{1}' ", nameof(RB_Member_CoffeeLog_Extend.Code), query.Code);
                }
            }
            return Get<RB_Member_CoffeeLog_Extend>(builder.ToString()).ToList();
        }
    }
}
