﻿using Mall.Model.Entity.Finance;
using Mall.Model.Extend.Finance;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Repository.Finance
{
    /// <summary>
    /// 账号类型扩展方法
    /// </summary>
    public class RB_AccountTypeRepository : BaseRepository<RB_AccountType>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_AccountType); } }


        /// <summary>
        /// 获取账号类型列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="model"></param>
        /// <param name="count"></param>
        /// <returns></returns>
        public List<RB_AccountType_Extend> GetPageList(int pageIndex, int pageSize, RB_AccountType_Extend model, out long count)
        {
            string where = string.Format(" where  A." + nameof(RB_AccountType_Extend.Status) + "={0}", (int)Common.Enum.DateStateEnum.Normal);
            if (model.RB_Group_Id > 0)
            {
                where += string.Format(" AND A." + nameof(RB_AccountType_Extend.RB_Group_Id) + "={0}", model.RB_Group_Id);
            }
            //if (model.RB_Branch_Id >= 0)
            //{
            //    where += string.Format(" AND A." + nameof(RB_AccountType_Extend.RB_Branch_Id) + "={0}", model.RB_Branch_Id);
            //}

            string sql = string.Format(" SELECT *,((SELECT COUNT(1) FROM rb_backaccount where TypeId=A.ID  AND `Status`=0)+(SELECT COUNT(1) FROM rb_cashaccount where TypeId=A.ID AND `Status`=0)+(SELECT COUNT(1) FROM rb_cashpoolaccount where TypeId=A.ID AND `Status`=0)+(SELECT COUNT(1) FROM rb_platformaccount where TypeId=A.ID AND `Status`=0)) as PeopleNum FROM {0}  as A {1}", TableName, where);
            return GetPage<RB_AccountType_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }

        /// <summary>
        /// 获取账号类型列表
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public List<RB_AccountType_Extend> GetList(RB_AccountType_Extend model)
        {
            string where = string.Format(" where " + nameof(RB_AccountType_Extend.Status) + "={0}", (int)Common.Enum.DateStateEnum.Normal);
            if (model.RB_Group_Id > 0)
            {
                where += string.Format(" AND " + nameof(RB_AccountType_Extend.RB_Group_Id) + "={0}", model.RB_Group_Id);
            }
            //if (model.RB_Branch_Id >= 0)
            //{
            //    where += string.Format(" AND " + nameof(RB_AccountType_Extend.RB_Branch_Id) + "={0}", model.RB_Branch_Id);
            //}
            if (model.IsPublic >= 0)
            {
                where += string.Format(" AND " + nameof(RB_AccountType_Extend.IsPublic) + "={0}", model.IsPublic);
            }
            if (!string.IsNullOrEmpty(model.Name))
            {
                where += string.Format(" AND " + nameof(RB_AccountType_Extend.Name) + " like '%{0}%'", model.Name);
            }

            string sql = string.Format(" SELECT * FROM {0} {1}", TableName, where);
            return Get<RB_AccountType_Extend>(sql).ToList();
        }
        /// <summary>
        /// 获取所有的账户信息列表
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public List<RB_BackAccount_Extend> GetAccountList(RB_BackAccount_Extend model)
        {
            string where = " where 1=1 ";
            if (model.BankType > 0)
            {
                where += string.Format(" AND t." + nameof(RB_BackAccount_Extend.BankType) + " ={0}", (int)model.BankType);
            }
            if (model.TypeId > 0)
            {
                where += string.Format(" AND t." + nameof(RB_BackAccount_Extend.TypeId) + " ={0}", model.TypeId);
            }
            if (!string.IsNullOrEmpty(model.Alias))
            {
                where += string.Format(" AND t." + nameof(RB_BackAccount_Extend.Alias) + " like '%{0}%' ", model.Alias);
            }
            if (model.BranchId >= 0)
            {
                where += string.Format(" AND t." + nameof(RB_BackAccount_Extend.BranchId) + " ={0}", model.BranchId);
            }
            string sql = string.Format(@"select t.ID,t.BranchId,t.Alias,t.AccountType as AccountTypeName,BackNo,t.backId,t.TypeId,t.BankType,t.CreateBy,t.CreateDate,t.CurrencyName,t.Rate,t.Initialbalance from ( 
 SELECT ID,BranchId,Alias,'银行' as AccountType,backNo AS BackNo,backId,TypeId,1 as BankType,CreateBy,CreateDate,(SELECT `Name` from rb_currency where ID=currencyId ) as CurrencyName,IFNULL((SELECT CurrentRate from rb_currency where ID=currencyId) ,0)as Rate,Initialbalance FROM rb_backaccount as A where `Status`=0
 UNION ALL
 SELECT ID,BranchId,Alias,'平台' as AccountType,PlatformNo AS BackNo,BackId as backId,TypeId,2 as BankType,CreateBy,CreateDate,(SELECT `Name` from rb_currency where ID=currencyId ) as CurrencyName,IFNULL((SELECT CurrentRate from rb_currency where ID=currencyId) ,0)as Rate,Initialbalance FROM rb_platformaccount as A where `Status`=0
 UNION ALL 
 SELECT ID,BranchId,Alias,'现金' as AccountType,'' AS BackNo,0 as backId,TypeId,3 as BankType,CreateBy,CreateDate,(SELECT `Name` from rb_currency where ID=currencyId ) as CurrencyName,IFNULL((SELECT CurrentRate from rb_currency where ID=currencyId) ,0)as Rate,Initialbalance FROM rb_cashaccount as A where `Status`=0  
 UNION ALL 
 SELECT ID,BranchId,Alias,'资金池' as AccountType,'' AS BackNo,0 as backId,TypeId,4 as BankType,CreateBy,CreateDate,(SELECT `Name` from rb_currency where ID=currencyId ) as CurrencyName,IFNULL((SELECT CurrentRate from rb_currency where ID=currencyId) ,0)as Rate,Initialbalance FROM rb_cashpoolaccount as A where `Status`=0  
)as t {0}", where);
            return Get<RB_BackAccount_Extend>(sql).ToList();
        }
        /// <summary>
        /// 通过公司ID获取公司对应的账户列表
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public List<RB_BackAccount_Extend> GetAccountByBranchList(RB_BackAccount_Extend model)
        {
            string where = " where 1=1 and a.`Status`=0 and a.Type=2  ";
            if (model.BankType > 0)
            {
                where += string.Format(" AND t." + nameof(RB_BackAccount_Extend.BankType) + " ={0}", (int)model.BankType);
            }
            if (model.RB_Branch_Id >= 0)
            {
                where += string.Format(" AND a." + nameof(RB_BackAccount_Extend.RB_Branch_Id) + " ={0}", model.RB_Branch_Id);
            }
            if (model.ID > 0)
            {
                where += string.Format(" AND t." + nameof(RB_BackAccount_Extend.ID) + " ={0}", model.ID);
            }
            if (model.TypeId > 0)
            {
                where += string.Format(" AND t." + nameof(RB_BackAccount_Extend.TypeId) + " ={0}", model.TypeId);
            }
            if (!string.IsNullOrEmpty(model.Alias))
            {
                where += string.Format(" AND t." + nameof(RB_BackAccount_Extend.Alias) + " like '%{0}%' ", model.Alias);
            }
            string sql = string.Format(@"select t.ID,t.Alias,t.AccountType as AccountTypeName,BackNo,t.backId,t.TypeId,t.BankType,t.CreateBy,t.CreateDate,t.CurrencyName,t.Rate,t.Initialbalance,IFNULL(a.RB_Branch_Id,-1) as RB_Branch_Id from ( 
 SELECT ID,Alias,'银行' as AccountType,BackNo AS BackNo,backId,TypeId,1 as BankType,CreateBy,CreateDate,(SELECT `Name` from rb_currency where ID=currencyId ) as CurrencyName,IFNULL((SELECT CurrentRate from rb_currency where ID=currencyId) ,0)as Rate,Initialbalance FROM rb_backaccount as A where `Status`=0
 UNION ALL
 SELECT ID,Alias,'平台' as AccountType,PlatformNo AS BackNo,BackId as backId,TypeId,2 as BankType,CreateBy,CreateDate,(SELECT `Name` from rb_currency where ID=currencyId ) as CurrencyName,IFNULL((SELECT CurrentRate from rb_currency where ID=currencyId) ,0)as Rate,Initialbalance FROM rb_platformaccount as A where `Status`=0
 UNION ALL 
 SELECT ID,Alias,'现金' as AccountType,'' AS BackNo,0 as backId,TypeId,3 as BankType,CreateBy,CreateDate,(SELECT `Name` from rb_currency where ID=currencyId ) as CurrencyName,IFNULL((SELECT CurrentRate from rb_currency where ID=currencyId) ,0)as Rate,Initialbalance FROM rb_cashaccount as A where `Status`=0  
 UNION ALL 
 SELECT ID,Alias,'资金池' as AccountType,'' AS BackNo,0 as backId,TypeId,4 as BankType,CreateBy,CreateDate,(SELECT `Name` from rb_currency where ID=currencyId ) as CurrencyName,IFNULL((SELECT CurrentRate from rb_currency where ID=currencyId) ,0)as Rate,Initialbalance FROM rb_cashpoolaccount as A where `Status`=0  
)as t LEFT JOIN rb_accountrelation as a on t.ID=a.AccountID AND t.BankType=a.AccountType {0}", where);
            return Get<RB_BackAccount_Extend>(sql).ToList();
        }
    }
}
