﻿using Mall.Model.Entity.GuideCar;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.GuideCar
{
    public class RB_GuideCar_CarSearchSearchRepository:BaseRepository<RB_GuideCar_CarSearch>
    {

        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_GuideCar_CarSearch); } }


        /// <summary>
        /// 司导-车辆搜索模块列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_GuideCar_CarSearch> GetGuideCarSearchList(RB_GuideCar_CarSearch query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_GuideCar_CarSearch.Status)}=0 ");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND {nameof(RB_GuideCar_CarSearch.ID)}={query.ID}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_GuideCar_CarSearch.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_GuideCar_CarSearch.MallBaseId)}={query.MallBaseId}");
                }
            }
            return Get<RB_GuideCar_CarSearch>(builder.ToString()).ToList();
        }
    }
}
