﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.Point;
using Mall.Model.Extend.Point;

namespace Mall.Repository.Point
{
    public class RB_Point_OrderRepository:BaseRepository<RB_Point_Order>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Point_Order); } }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_Order_Extend> GetPointOrderList(RB_Point_Order_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT * from RB_Point_Order  where state=0");
            if (where != null)
            {
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and TenantId={0}", where.TenantId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and MallBaseId={0}", where.MallBaseId);
                }
                if (where.ID > 0)
                {
                    sb.AppendFormat(" and ID={0}", where.ID);
                }
            }
            return Get<RB_Point_Order_Extend>(sb.ToString()).ToList();
        }




        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_Order_Extend> GetPointOrderPageList(int pageIndex, int pageSize, out long rowsCount, RB_Point_Order_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT a.*,b.`Name` as UserName,b.Photo as UserPhoto from RB_Point_order as a LEFT JOIN rb_member_user as b  on a.UserId=b.Id where a.state=0 ");
            if (where != null)
            {
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and a.TenantId={0}", where.TenantId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and a.MallBaseId={0}", where.MallBaseId);
                }
                if (where.ID > 0)
                {
                    sb.AppendFormat(" and a.ID={0}", where.ID);
                }
                if (where.OrderStatus > 0)
                {
                    sb.AppendFormat(" and a.OrderStatus={0}", where.OrderStatus);
                }
                if (where.UserId > 0)
                {
                    sb.AppendFormat(" and a.UserId={0}", where.UserId);
                }
                if (!string.IsNullOrEmpty(where.OrderNo))
                {
                    sb.AppendFormat(" and a.OrderNo like '%{0}%'", where.OrderNo);
                }
            }
            sb.Append(" order by a.ID desc");
            return GetPage<RB_Point_Order_Extend>(pageIndex, pageSize, out rowsCount, sb.ToString()).ToList();
        }
    }
}
