﻿using Mall.Common.Enum;
using Mall.Common.Enum.Goods;
using Mall.Common.Enum.User;
using System;
using VT.FW.DB;

namespace Mall.Model.Entity.TradePavilion
{
    /// <summary>
    /// 商会活动评论表实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Commerce_Comment
    {
		/// <summary>
		/// 主键编号
		/// </summary>
		public int Id { get; set; }

		/// <summary>
		/// 活动编号
		/// </summary>
		public int ActivityId { get; set; }

		/// <summary>
		/// 用户编号
		/// </summary>
		public int UserId { get; set; }

		/// <summary>
		/// 客人名称
		/// </summary>
		public string UserName { get; set; }

		/// <summary>
		/// 用户头像
		/// </summary>
		public string UserPhoto { get; set; }

		/// <summary>
		/// 评分 1-5分
		/// </summary>
		public int CommentScore { get; set; }

		/// <summary>
		/// 评论类型  1 好评  2中评   3差评
		/// </summary>
		public GoodsCommentTypeEnum CommentGrade { get; set; }

		/// <summary>
		/// 评论内容
		/// </summary>
		public string Content { get; set; }

		/// <summary>
		/// 评论图片
		/// </summary>
		public string CommentImage { get; set; }

		/// <summary>
		/// 回复
		/// </summary>
		public string Reply { get; set; }

		/// <summary>
		/// 来源
		/// </summary>
		public UserSourceEnum PlatformSource { get; set; }

		/// <summary>
		/// 是否置顶  1是  2否
		/// </summary>
		public int Is_Top { get; set; }

		/// <summary>
		/// 是否显示   1是  2否
		/// </summary>
		public int Is_Show { get; set; }

		/// <summary>
		/// 是否匿名  1是  2否
		/// </summary>
		public int Is_Anonymity { get; set; }

		/// <summary>
		/// 删除状态
		/// </summary>
		public DateStateEnum Status { get; set; }

		/// <summary>
		/// 商户号
		/// </summary>
		public int TenantId { get; set; }

		/// <summary>
		/// 小程序id
		/// </summary>
		public int MallBaseId { get; set; }

		/// <summary>
		/// CreateDate
		/// </summary>
		public DateTime CreateDate { get; set; }

		/// <summary>
		/// UpdateDate
		/// </summary>
		public DateTime UpdateDate { get; set; }
	}
}
