﻿using Mall.Common.Plugin;
using Mall.Model.Entity.Reserve;
using Mall.Model.Extend.Reserve;
using Mall.Repository.Reserve;
using Mall.Repository.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB;

namespace Mall.Module.Reserve
{
    public class ReserveModule
    {

        /// <summary>
        /// 小程序
        /// </summary>
        private readonly RB_MiniProgramRepository miniProgramRepository = new RB_MiniProgramRepository();

        #region 套餐卡
        private readonly RB_Reserve_CouponRepository discountCouponRepository = new RB_Reserve_CouponRepository();
        private readonly RB_Reserve_CouponProductRepository productRepository = new RB_Reserve_CouponProductRepository();
        private readonly RB_Reserve_MemberUseCouponRepository memberUseCouponRepository = new RB_Reserve_MemberUseCouponRepository();
        private readonly RB_Reserve_MemberCouponRepository memberCouponRepository = new RB_Reserve_MemberCouponRepository();
        private readonly RB_Reserve_CouponSelfMotionMemberRepository selfMotionMemberRepository = new RB_Reserve_CouponSelfMotionMemberRepository();
        private readonly RB_Reserve_CouponSelfMotionRepository selfMotionRepository = new RB_Reserve_CouponSelfMotionRepository();
        #endregion


        #region 服务人员
        private readonly RB_Reserve_ServicePersonalProductRepository servicePersonalProductRepository = new RB_Reserve_ServicePersonalProductRepository();
        private readonly RB_Reserve_ServicePersonalRepository servicePersonalRepository = new RB_Reserve_ServicePersonalRepository();
        private readonly RB_Reserve_ServiceTargetDateRepository serviceTargetDateRepository = new RB_Reserve_ServiceTargetDateRepository();

        #endregion



        #region 服务人员信息
        /// <summary>
        /// 套餐卡信息列表 订单数和商品数还未关联
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_ServicePersonal_Extend> GetServicePersonalPageList(int pageIndex, int pageSize, out long rowCount, RB_Reserve_ServicePersonal_Extend query)
        {
            var list = servicePersonalRepository.GetServicePersonalPageList(pageIndex, pageSize, out rowCount, query);
            //if (list != null && list.Any())
            //{

            //    string Ids = string.Join(",", list.Where(x => x.ServiceType == Common.Enum.Reserve.ServiceTypeEnum.Category || x.ServiceType == Common.Enum.Reserve.ServiceTypeEnum.Product).Select(x => x.ID));
            //    var listProduct = servicePersonalProductRepository.GetListByServicePersonalProductIds(query, Ids);
            //    foreach (var item in list)
            //    {
            //        item.ProductList = new List<RB_Reserve_ServicePersonalProduct_Extend>();
            //        item.ProductList = listProduct.Where(x => x.ServiceId == item.ID).ToList();
            //    }
            //}
            return list;
        }


        /// <summary>
        /// 服务人员信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_ServicePersonal_Extend> GetServicePersonalList(RB_Reserve_ServicePersonal_Extend query, bool IsSelectDel = false)
        {
            var list = servicePersonalRepository.GetServicePersonalList(query, IsSelectDel);
            if (list != null && list.Any())
            {

                string Ids = string.Join(",", list.Where(x => x.ServiceType == Common.Enum.Reserve.ServiceTypeEnum.Category || x.ServiceType == Common.Enum.Reserve.ServiceTypeEnum.Product).Select(x => x.ID));
                var listProduct = servicePersonalProductRepository.GetListByServicePersonalProductIds(query, Ids);
                foreach (var item in list)
                {
                    item.ProductList = new List<RB_Reserve_ServicePersonalProduct_Extend>();
                    item.ProductList = listProduct.Where(x => x.ServiceId == item.ID).ToList();
                }
            }
            return list;
        }

        /// <summary>
        /// 新增/修改服务人员
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateServicePersonal(RB_Reserve_ServicePersonal_Extend model)
        {
            bool flag = false;
            var trans = servicePersonalRepository.DbTransaction;
            try
            {
                int id = 0;
                if (model.ID == 0)
                {
                    id = servicePersonalRepository.Insert(model, trans);
                    if (id > 0 && model.ProductList != null && model.ProductList.Any())
                    {
                        model.ProductList.ForEach(x => x.ServiceType = model.ServiceType);
                        model.ProductList.ForEach(x => x.MallBaseId = model.MallBaseId);
                        model.ProductList.ForEach(x => x.TenantId = model.TenantId);
                        model.ProductList.ForEach(x => x.CreateDate = model.CreateDate);
                        model.ProductList.ForEach(x => x.UpdateDate = model.UpdateDate);
                        model.ProductList.ForEach(x => x.ServiceId = id);
                        flag = servicePersonalProductRepository.InsertBatch(model.ProductList, trans);
                    }
                    flag = id > 0;
                }
                else
                {
                    id = model.ID;
                    flag = servicePersonalRepository.Update(model, trans);
                    IDictionary<string, object> fileds = new Dictionary<string, object>()
                         {
                            { nameof(RB_Reserve_ServicePersonalProduct.Status),1},
                             { nameof(RB_Reserve_ServicePersonalProduct.UpdateDate),model.UpdateDate},
                          };
                    IList<WhereHelper> whereHelpers = new List<WhereHelper>()
                        {
                            new WhereHelper (){ FiledName=nameof(RB_Reserve_ServicePersonalProduct.ServiceId),FiledValue=id,OperatorEnum=OperatorEnum.Equal}
                        };
                    servicePersonalProductRepository.Update(fileds, whereHelpers, trans);

                    if (model.ProductList != null && model.ProductList.Any())
                    {
                        model.ProductList.ForEach(x => x.ServiceType = model.ServiceType);
                        model.ProductList.ForEach(x => x.MallBaseId = model.MallBaseId);
                        model.ProductList.ForEach(x => x.TenantId = model.TenantId);
                        model.ProductList.ForEach(x => x.CreateDate = model.CreateDate);
                        model.ProductList.ForEach(x => x.UpdateDate = model.UpdateDate);
                        model.ProductList.ForEach(x => x.ServiceId = id);
                        flag = servicePersonalProductRepository.InsertBatch(model.ProductList, trans);
                    }
                }
                servicePersonalRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateServicePersonal");
                servicePersonalRepository.DBSession.Rollback("AddOrUpdateServicePersonal");
                return false;
            }
            return flag;
        }

        /// <summary>
        /// 批量启用/禁用服务人员
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool EnableServicePersonalInfo(List<string> ids, int TeacherStatus, int uid, int mallBaseId)
        {
            var trans = servicePersonalRepository.DbTransaction;
            bool flag = false;
            try
            {
                foreach (var item in ids)
                {
                    if (!string.IsNullOrWhiteSpace(item))
                    {
                        Dictionary<string, object> cols = new Dictionary<string, object>()
                        {
                            { nameof(RB_Reserve_ServicePersonal.ServiceStatus),TeacherStatus},
                            { nameof(RB_Reserve_ServicePersonal.UpdateDate),DateTime.Now},
                        };
                        List<WhereHelper> wheres1 = new List<WhereHelper>() {
                            new WhereHelper(){
                                    FiledName=nameof(RB_Reserve_ServicePersonal.ID),
                                    FiledValue=Convert.ToInt32(item),
                                    OperatorEnum=OperatorEnum.Equal
                            },
                            new WhereHelper(){
                                    FiledName=nameof(RB_Reserve_ServicePersonal.TenantId),
                                    FiledValue=Convert.ToInt32(uid),
                                    OperatorEnum=OperatorEnum.Equal
                            },
                            new WhereHelper(){
                                    FiledName=nameof(RB_Reserve_ServicePersonal.MallBaseId),
                                    FiledValue=Convert.ToInt32(mallBaseId),
                                    OperatorEnum=OperatorEnum.Equal
                            }
                        };
                        flag = servicePersonalRepository.Update(cols, wheres1, trans);
                    }
                }
                servicePersonalRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "EnableServicePersonalInfo");
                servicePersonalRepository.DBSession.Rollback("EnableServicePersonalInfo");
                return false;
            }
            return flag;
        }





        #endregion




        #region 套餐卡
        /// <summary>
        /// 套餐卡信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_Coupon_Extend> GetDiscountCouponPageList(int pageIndex, int pageSize, out long rowCount, RB_Reserve_Coupon_Extend query)
        {
            return discountCouponRepository.GetDiscountCouponPageList(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 套餐卡信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_Coupon_Extend> GetDiscountCouponList(RB_Reserve_Coupon_Extend query)
        {
            var list = discountCouponRepository.GetDiscountCouponList(query);
            if (list != null && list.Any())
            {

                string Ids = string.Join(",", list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category || x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product).Select(x => x.ID));
                var listProduct = productRepository.GetListByDiscountCouponIds(query, Ids);
                foreach (var item in list)
                {
                    item.ProductList = new List<RB_Reserve_CouponProduct_Extend>();
                    item.ProductList = listProduct.Where(x => x.CouponId == item.ID).ToList();
                }
            }
            return list;

        }

        /// <summary>
        /// 套餐卡信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_Coupon_Extend> GetAllDiscountCouponList(RB_Reserve_Coupon_Extend query)
        {
            return discountCouponRepository.GetDiscountCouponList(query);

        }



        /// <summary>
        /// 新增/修改套餐卡
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateDiscountCoupon(RB_Reserve_Coupon_Extend model)
        {
            bool flag = false;
            var trans = discountCouponRepository.DbTransaction;
            try
            {
                int id = 0;
                if (model.ID == 0)
                {
                    id = discountCouponRepository.Insert(model, trans);
                    if (id > 0 && model.ProductList != null && model.ProductList.Any())
                    {
                        model.ProductList.ForEach(x => x.ServiceType = model.UseType);
                        model.ProductList.ForEach(x => x.MallBaseId = model.MallBaseId);
                        model.ProductList.ForEach(x => x.TenantId = model.TenantId);
                        model.ProductList.ForEach(x => x.CreateDate = model.CreateDate);
                        model.ProductList.ForEach(x => x.UpdateDate = model.UpdateDate);
                        model.ProductList.ForEach(x => x.CouponId = id);
                        flag = productRepository.InsertBatch(model.ProductList, trans);
                    }
                    flag = id > 0;
                }
                else
                {
                    id = model.ID;
                    flag = discountCouponRepository.Update(model, trans);
                    IDictionary<string, object> fileds = new Dictionary<string, object>()
                         {
                            { nameof(RB_Reserve_CouponProduct.Status),1},
                             { nameof(RB_Reserve_CouponProduct.UpdateDate),model.UpdateDate},
                          };
                    IList<WhereHelper> whereHelpers = new List<WhereHelper>()
                        {
                            new WhereHelper (){ FiledName=nameof(RB_Reserve_CouponProduct.CouponId),FiledValue=id,OperatorEnum=OperatorEnum.Equal}
                        };
                    productRepository.Update(fileds, whereHelpers, trans);

                    if (model.ProductList != null && model.ProductList.Any())
                    {
                        model.ProductList.ForEach(x => x.ServiceType = model.UseType);
                        model.ProductList.ForEach(x => x.MallBaseId = model.MallBaseId);
                        model.ProductList.ForEach(x => x.TenantId = model.TenantId);
                        model.ProductList.ForEach(x => x.CreateDate = model.CreateDate);
                        model.ProductList.ForEach(x => x.UpdateDate = model.UpdateDate);
                        model.ProductList.ForEach(x => x.CouponId = id);
                        flag = productRepository.InsertBatch(model.ProductList, trans);
                    }
                }
                discountCouponRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateDiscountCoupon");
                discountCouponRepository.DBSession.Rollback("AddOrUpdateDiscountCoupon");
                return false;
            }
            return flag;
        }

        /// <summary>
        /// 删除套餐卡
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelDiscountCoupon(int id, int uid, int mallBaseId)
        {
            var trans = discountCouponRepository.DbTransaction;
            bool flag;
            try
            {
                Dictionary<string, object> cols1 = new Dictionary<string, object>()
                    {
                        { nameof(RB_Reserve_Coupon.Status),1},
                        { nameof(RB_Reserve_Coupon.UpdateDate),DateTime.Now},
                    };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_Coupon.ID),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_Coupon.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_Coupon.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                flag = discountCouponRepository.Update(cols1, wheres1);

                Dictionary<string, object> cols = new Dictionary<string, object>()
                    {
                        { nameof(RB_Reserve_Coupon.Status),1},
                        { nameof(RB_Reserve_Coupon.UpdateDate),DateTime.Now},
                    };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_CouponProduct.CouponId),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_CouponProduct.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_CouponProduct.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                productRepository.Update(cols, wheres);


                discountCouponRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelDiscountCoupon");
                discountCouponRepository.DBSession.Rollback("DelDiscountCoupon");
                return false;
            }
            return flag;
        }





        /// <summary>
        /// 删除会员套餐卡
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelMemberCoupon(int id, int uid, int mallBaseId)
        {
            bool flag;
            try
            {
                Dictionary<string, object> cols1 = new Dictionary<string, object>()
                    {
                        { nameof(RB_Reserve_MemberCoupon.Status),1},
                        { nameof(RB_Reserve_MemberCoupon.Remarks),System.DateTime.Now+"删除"},
                    };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_MemberCoupon.Id),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_MemberCoupon.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_MemberCoupon.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                flag = memberCouponRepository.Update(cols1, wheres1);
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelMemberCoupon");
                return false;
            }
            return flag;
        }



        /// <summary>
        /// 领劵中心
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool UpdatePickupType(int id, int uid, int mallBaseId)
        {
            try
            {
                var model = discountCouponRepository.GetEntity(id);

                Dictionary<string, object> cols1 = new Dictionary<string, object>()
                    {
                        { nameof(RB_Reserve_Coupon.PickupCenter),model.PickupCenter==0?1:0},
                        { nameof(RB_Reserve_Coupon.UpdateDate),DateTime.Now},
                    };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_Coupon.ID),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_Coupon.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_Coupon.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                return discountCouponRepository.Update(cols1, wheres1);


            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "UpdatePickupType");
                return false;
            }
        }



        /// <summary>
        /// 发放套餐卡
        /// </summary>
        /// <param name="list"></param>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool GrantCoupon(List<RB_Reserve_MemberCoupon_Extend> list, RB_Reserve_Coupon_Extend model)
        {
            var trans = memberCouponRepository.DbTransaction;
            bool flag;
            try
            {
                flag = memberCouponRepository.InsertBatch(list, trans);
                if (model != null && flag)
                {
                    Dictionary<string, object> cols1;
                    if (model.TotalNum != -1)
                    {
                        cols1 = new Dictionary<string, object>()
                        {
                            { nameof(RB_Reserve_Coupon.ReceiveNum),model.ReceiveNum+list.Count()},
                            { nameof(RB_Reserve_Coupon.TotalNum),model.TotalNum - list.Count()},
                            { nameof(RB_Reserve_Coupon.UpdateDate),DateTime.Now},
                        };
                    }
                    else
                    {
                        cols1 = new Dictionary<string, object>()
                        {
                            { nameof(RB_Reserve_Coupon.ReceiveNum),model.ReceiveNum+list.Count()},

                            { nameof(RB_Reserve_Coupon.UpdateDate),DateTime.Now},
                        };
                    }
                    List<WhereHelper> wheres1 = new List<WhereHelper>()
                    {
                    new WhereHelper(){
                            FiledName=nameof(RB_Reserve_Coupon.ID),
                            FiledValue=model.ID,
                            OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper(){
                            FiledName=nameof(RB_Reserve_Coupon.TenantId),
                            FiledValue=model.TenantId,
                            OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper(){
                            FiledName=nameof(RB_Reserve_Coupon.MallBaseId),
                            FiledValue=model.MallBaseId,
                            OperatorEnum=OperatorEnum.Equal
                    }
                    };
                    flag = discountCouponRepository.Update(cols1, wheres1, trans);
                }
                memberCouponRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "GrantCoupon");
                memberCouponRepository.DBSession.Rollback("GrantCoupon");
                return false;
            }
            return flag;
        }


        /// <summary>
        /// 根据用户id和商品分类以及商品id获取未使用的套餐卡信息
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_Coupon_Extend> GetNoUseCouponList(RB_Reserve_Coupon_Extend query)
        {
            var list = discountCouponRepository.GetNoUseCouponList(query);
            //获取特定商品或者分类的数据
            string Ids = string.Join(",", list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category).Select(x => x.ID));
            if (!string.IsNullOrWhiteSpace(Ids))
            {
                query.UseType = Common.Enum.MarketingCenter.UseTypeEnum.Category;
                var listProduct = productRepository.GetListByDiscountCouponIds(query, Ids);
                foreach (var item in list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category))
                {
                    item.ProductList = new List<RB_Reserve_CouponProduct_Extend>();
                    item.ProductList = listProduct.Where(x => x.CouponId == item.ID).ToList();
                }
            }
            Ids = string.Join(",", list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product).Select(x => x.ID));
            if (!string.IsNullOrWhiteSpace(Ids))
            {
                query.UseType = Common.Enum.MarketingCenter.UseTypeEnum.Product;
                var listProduct = productRepository.GetListByDiscountCouponIds(query, Ids);
                foreach (var item in list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product))
                {
                    item.ProductList = new List<RB_Reserve_CouponProduct_Extend>();
                    item.ProductList = listProduct.Where(x => x.CouponId == item.ID).ToList();
                }
            }

            return list;
        }


        #endregion


        #region 自动发放套餐卡规则
        /// <summary>
        /// 自动发放套餐卡规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_CSelfMotion_Extend> GetSelfMotionPageLis(int pageIndex, int pageSize, out long rowCount, RB_Reserve_CSelfMotion_Extend query)
        {
            return selfMotionRepository.GetSelfMotionPageLis(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 自动发放套餐卡规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_CSelfMotion_Extend> GettRepositoryList(RB_Reserve_CSelfMotion_Extend query)
        {
            var list = selfMotionRepository.GettRepositoryList(query);

            return list;
        }



        /// <summary>
        /// 获取发放套餐卡的人员信息
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_CSelfMotionMember_Extend> GetSelfMotionMemberList(RB_Reserve_CSelfMotionMember_Extend query)
        {
            return selfMotionMemberRepository.GetListRepository(query);
        }


        /// <summary>
        /// 新增/修改自动发放套餐卡
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateSelfMotion(RB_Reserve_CSelfMotion_Extend model)
        {
            bool flag = false;
            var trans = selfMotionRepository.DbTransaction;
            try
            {
                int id = 0;
                if (model.ID == 0)
                {
                    id = selfMotionRepository.Insert(model, trans);
                    if (id > 0 && model.UserList != null && model.UserList.Any())
                    {
                        model.UserList.ForEach(x => x.MallBaseId = model.MallBaseId);
                        model.UserList.ForEach(x => x.TenantId = model.TenantId);
                        model.UserList.ForEach(x => x.CreateDate = model.CreateDate);
                        model.UserList.ForEach(x => x.UpdateDate = model.UpdateDate);
                        model.UserList.ForEach(x => x.SelfMotionId = id);
                        flag = selfMotionMemberRepository.InsertBatch(model.UserList, trans);
                    }
                    flag = id > 0;
                }
                else
                {
                    id = model.ID;
                    flag = selfMotionRepository.Update(model, trans);

                    IDictionary<string, object> fileds = new Dictionary<string, object>()
                         {
                            { nameof(RB_Reserve_CouponSelfMotionMember.Status),1},
                             { nameof(RB_Reserve_CouponSelfMotionMember.UpdateDate),model.UpdateDate},
                          };
                    IList<WhereHelper> whereHelpers = new List<WhereHelper>()
                        {
                            new WhereHelper (){ FiledName=nameof(RB_Reserve_CouponSelfMotionMember.SelfMotionId),FiledValue=model.ID,OperatorEnum=OperatorEnum.Equal},
                             new WhereHelper (){ FiledName=nameof(RB_Reserve_CouponSelfMotionMember.MallBaseId),FiledValue=model.MallBaseId,OperatorEnum=OperatorEnum.Equal},
                              new WhereHelper (){ FiledName=nameof(RB_Reserve_CouponSelfMotionMember.TenantId),FiledValue=model.TenantId,OperatorEnum=OperatorEnum.Equal}
                        };
                    selfMotionMemberRepository.Update(fileds, whereHelpers, trans);


                    if (model.UserList != null && model.UserList.Any())
                    {
                        model.UserList.ForEach(x => x.MallBaseId = model.MallBaseId);
                        model.UserList.ForEach(x => x.TenantId = model.TenantId);
                        model.UserList.ForEach(x => x.CreateDate = model.CreateDate);
                        model.UserList.ForEach(x => x.UpdateDate = model.UpdateDate);
                        model.UserList.ForEach(x => x.SelfMotionId = id);
                        flag = selfMotionMemberRepository.InsertBatch(model.UserList, trans);
                    }
                }
                selfMotionRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateSelfMotion");
                selfMotionRepository.DBSession.Rollback("AddOrUpdateSelfMotion");
                return false;
            }
            return flag;
        }

        /// <summary>
        /// 删除自动发放套餐卡
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelDiscountSelfMotion(int id, int uid, int mallBaseId)
        {
            var trans = selfMotionRepository.DbTransaction;
            bool flag;
            try
            {
                Dictionary<string, object> cols1 = new Dictionary<string, object>()
                    {
                        { nameof(RB_Reserve_CouponSelfMotion.Status),1},
                        { nameof(RB_Reserve_CouponSelfMotion.UpdateDate),DateTime.Now},
                    };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_CouponSelfMotion.ID),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_CouponSelfMotion.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_CouponSelfMotion.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                flag = selfMotionRepository.Update(cols1, wheres1);

                Dictionary<string, object> cols = new Dictionary<string, object>()
                    {
                        { nameof(RB_Reserve_CouponSelfMotionMember.Status),1},
                        { nameof(RB_Reserve_CouponSelfMotionMember.UpdateDate),DateTime.Now},
                    };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_CouponSelfMotionMember.SelfMotionId),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_CouponSelfMotionMember.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_CouponSelfMotionMember.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                selfMotionMemberRepository.Update(cols, wheres);


                selfMotionRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelDiscountSelfMotion");
                selfMotionRepository.DBSession.Rollback("DelDiscountSelfMotion");
                return false;
            }
            return flag;
        }


        #endregion


        #region 会员套餐卡
        /// <summary>
        /// 我的套餐卡
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_Coupon_Extend> GetMemberDisCouponList(int pageIndex, int pageSize, out long rowCount, RB_Reserve_Coupon_Extend query)
        {
            var list = discountCouponRepository.GetMemberDisCouponList(pageIndex, pageSize, out rowCount, query);
            //获取特定商品或者分类的数据
            string Ids = string.Join(",", list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category).Select(x => x.ID));
            if (!string.IsNullOrWhiteSpace(Ids))
            {
                query.UseType = Common.Enum.MarketingCenter.UseTypeEnum.Category;
                var listProduct = productRepository.GetListByDiscountCouponIds(query, Ids);
                foreach (var item in list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category))
                {
                    item.ProductList = new List<RB_Reserve_CouponProduct_Extend>();
                    item.ProductList = listProduct.Where(x => x.CouponId == item.ID).ToList();
                }
            }
            Ids = string.Join(",", list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product).Select(x => x.ID));
            if (!string.IsNullOrWhiteSpace(Ids))
            {
                query.UseType = Common.Enum.MarketingCenter.UseTypeEnum.Product;
                var listProduct = productRepository.GetListByDiscountCouponIds(query, Ids);
                foreach (var item in list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product))
                {
                    item.ProductList = new List<RB_Reserve_CouponProduct_Extend>();
                    item.ProductList = listProduct.Where(x => x.CouponId == item.ID).ToList();
                }
            }
            return list;
        }
        #endregion
    }
}
