﻿using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.User
{

    /// <summary>
    /// 管理提醒日志表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Message_Notice
    {
        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 来源id （订单Id/售后订单Id）
        /// </summary>        
        public int SourceId
        {
            get;
            set;
        }
        /// <summary>
        /// 来源类型  1下单   2退款   3售后
        /// </summary>        
        public int Type
        {
            get;
            set;
        }
        /// <summary>
        /// 是否已看   1是  2否
        /// </summary>        
        public int IsLook
        {
            get;
            set;
        }

        /// <summary>
        /// 用户ID
        /// </summary>
        public int UserId { get; set; }

        /// <summary>
        /// 相关订单号/售后单号
        /// </summary>
        public string OrderNo { get; set; }

        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime CreateDate
        {
            get;
            set;
        }
    }
}
