﻿using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using Mall.Repository.Product;
using System;
using System.Collections.Generic;
using System.Linq;


namespace Mall.Module.Product
{
    /// <summary>
    /// 拼团活动处理类
    /// </summary>
    public partial class GroupBuyActivityModule
    {
        /// <summary>
        /// 拼团活动仓储层对象
        /// </summary>
        private readonly RB_Groupbuy_ActivityRepository groupbuy_ActivityRepository = new RB_Groupbuy_ActivityRepository();

        /// <summary>
        /// 拼团活动商品规格价格仓储层对象
        /// </summary>
        private readonly RB_Groupbuy_Activity_SpecificationPriceRepository groupbuy_Activity_SpecificationPriceRepository = new RB_Groupbuy_Activity_SpecificationPriceRepository();

        /// <summary>
        /// 拼团活动商品关联规格值仓储层对象
        /// </summary>
        private readonly RB_Groupbuy_Activity_SpecificationValueRepository groupbuy_Activity_SpecificationValueRepository = new RB_Groupbuy_Activity_SpecificationValueRepository();

        /// <summary>
        /// 拼团商品关联规格仓储层对象
        /// </summary>
        private readonly RB_Groupbuy_Activity_SpecificationRepository groupbuy_Activity_SpecificationRepository = new RB_Groupbuy_Activity_SpecificationRepository();

        /// <summary>
        /// 阶梯团仓储层对象
        /// </summary>
        private readonly RB_Groupbuy_Activity_StepRepository stepRepository = new RB_Groupbuy_Activity_StepRepository();

        /// <summary>
        /// 拼团活动商品阶梯价格仓储层对象
        /// </summary>
        private readonly RB_Groupbuy_Activity_Step_PriceRepository groupbuy_Activity_Step_PriceRepository = new RB_Groupbuy_Activity_Step_PriceRepository();

        /// <summary>
        /// 拼团活动商品关联分销佣金表仓储对象
        /// </summary>
        private readonly RB_GroupBuy_DistributioncommissionRepository groupBuy_DistributioncommissionRepository = new RB_GroupBuy_DistributioncommissionRepository();

        /// <summary>
        /// 拼团活动商品关联会员价格表仓储对象
        /// </summary>
        private readonly RB_Groupbuy_MemberpriceRepository groupbuy_MemberpriceRepository = new RB_Groupbuy_MemberpriceRepository();

        /// <summary>
        /// 拼团商品区域仓储层对象
        /// </summary>
        private readonly RB_GroupBuy_AreaRepository groupbuy_AreaRepository = new RB_GroupBuy_AreaRepository();


        /// <summary>
        /// 根据查询条件获取地区信息
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_GroupBuy_Area_Extend> GetGroupBuyAreaModule(RB_GroupBuy_Area_Extend query)
        {
            return groupbuy_AreaRepository.GetGroupBuyAreaRepository(query);
        }

        /// <summary>
        /// 获取拼团活动商品分销佣金
        /// </summary>
        /// <returns></returns>
        public List<RB_Groupbuy_Memberprice_Extend> GetGroupBuyMemberpriceModule(RB_Groupbuy_Memberprice_Extend query)
        {
            return groupbuy_MemberpriceRepository.GetGroupBuyMemberpriceRepository(query);
        }

        /// <summary>
        /// 获取拼团活动商品分销佣金
        /// </summary>
        /// <returns></returns>
        public List<RB_GroupBuy_Distributioncommission_Extend> GetGroupBuyCommissionModule(RB_GroupBuy_Distributioncommission_Extend query)
        {
            return groupBuy_DistributioncommissionRepository.GetGroupBuyCommissionRepository(query);
        }


        /// <summary>
        /// 获取拼团活动商品规格价格列表
        /// </summary>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Groupbuy_Activity_Step_Price_Extend> GetGroupbuyActivitySpecificationpriceListModule(RB_Groupbuy_Activity_Step_Price_Extend query)
        {
            return groupbuy_Activity_Step_PriceRepository.GetGroupbuyActivitySpecificationpriceListRepository(query);
        }

        /// <summary>
        /// 获取拼团活动阶梯价列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Groupbuy_Activity_Step_Extend> GetGroupBuyActivityListModule(RB_Groupbuy_Activity_Step_Extend query)
        {
            return stepRepository.GetGroupBuyActivityListRepository(query);
        }

        /// <summary>
        /// 获取拼团活动商品规格价格列表
        /// </summary>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Groupbuy_Activity_Specificationprice_Extend> GetGroupbuyActivitySpecificationpriceListModule(RB_Groupbuy_Activity_Specificationprice_Extend dmodel)
        {
            return groupbuy_Activity_SpecificationPriceRepository.GetGroupbuyActivitySpecificationpriceListRepository(dmodel);
        }

        /// <summary>
        /// 获取拼团活动商品关联规格值列表
        /// </summary>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Groupbuy_Activity_Specificationvalue_Extend> GetGroupbuyActivitySpecificationValueListModule(RB_Groupbuy_Activity_Specificationvalue_Extend dmodel)
        {
            return groupbuy_Activity_SpecificationValueRepository.GetGroupbuyActivitySpecificationValueListRepository(dmodel);
        }

        /// <summary>
        /// 获取拼团商品关联规格列表
        /// </summary>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Groupbuy_Activity_Specification_Extend> GetGroupbuyActivitySpecificationListModule(RB_Groupbuy_Activity_Specification_Extend dmodel)
        {
            return groupbuy_Activity_SpecificationRepository.GetGroupbuyActivitySpecificationListRepository(dmodel);
        }


        /// <summary>
        ///  获取拼团活动分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowsCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Groupbuy_Activity_Extend> GetGroupbuyActivityPageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Groupbuy_Activity_Extend query)
        {
            var list = groupbuy_ActivityRepository.GetGroupbuyActivityPageListRepository(pageIndex, pageSize, out rowsCount, query);
            if (list != null && list.Count > 0)
            {
                string Ids = string.Join(",", list.Select(qitem => qitem.GoodId));
                //拼团阶梯基础设置列表
                List<RB_Groupbuy_Activity_Step_Extend> groupStepList = GetGroupBuyActivityListModule(new RB_Groupbuy_Activity_Step_Extend()
                {
                    MallBaseId = query.MallBaseId,
                    TenantId = query.TenantId,
                    GoodIds = Ids,
                });
                //拼团阶梯价格设置列表
                List<RB_Groupbuy_Activity_Step_Price_Extend> StepPriceList = GetGroupbuyActivitySpecificationpriceListModule(new RB_Groupbuy_Activity_Step_Price_Extend()
                {
                    MallBaseId = query.MallBaseId,
                    TenantId = query.TenantId,
                    GoodsIds = Ids,
                });

                if (groupStepList != null && groupStepList.Count > 0)
                {
                    foreach (var item in groupStepList)
                    {
                        item.StepPriceList = StepPriceList?.Where(qitem => qitem.GoodId == item.GoodId && qitem.StepId == item.StepId)?.ToList() ?? new List<RB_Groupbuy_Activity_Step_Price_Extend>();
                    }
                }
                foreach (var item in list)
                {
                    item.GroupList = groupStepList?.Where(qitem => qitem.GoodId == item.GoodId)?.ToList() ?? new List<RB_Groupbuy_Activity_Step_Extend>();
                }
            }
            return list;
        }

        /// <summary>
        /// 获取活动实体类
        /// </summary>
        /// <param name="query"></param>
        /// <param name="isGetSpec">是否获取规格信息</param>
        /// <returns></returns>
        public RB_Groupbuy_Activity_Extend GetGroupbuyActivityEntityModule(RB_Groupbuy_Activity_Extend query, bool isGetSpec = false)
        {
            var extModel = groupbuy_ActivityRepository.GetGroupbuyActivityEntityRepository(query);
            if (extModel == null)
            {
                extModel = new RB_Groupbuy_Activity_Extend();
            }
            if (!string.IsNullOrWhiteSpace(extModel.GoodsService))
            {
                extModel.ServiceList = Common.Plugin.JsonHelper.DeserializeObject<List<RB_ImageCommonModel>>(extModel.GoodsService);
            }
            if (isGetSpec)
            {
                //获取规格列表
                List<RB_Groupbuy_Activity_Specification_Extend> specificationList = GetGroupbuyActivitySpecificationListModule(new RB_Groupbuy_Activity_Specification_Extend()
                {
                    MallBaseId = query.MallBaseId,
                    TenantId = query.TenantId,
                    GoodsId = extModel.GoodId,
                });

                //规格值列表
                List<RB_Groupbuy_Activity_Specificationvalue_Extend> specificationvalueList = GetGroupbuyActivitySpecificationValueListModule(new RB_Groupbuy_Activity_Specificationvalue_Extend()
                {
                    MallBaseId = query.MallBaseId,
                    TenantId = query.TenantId,
                    GoodsId = extModel.GoodId,
                });
                if (specificationList != null && specificationList.Count > 0)
                {
                    foreach (var item in specificationList)
                    {
                        item.SpecificationValueList = specificationvalueList?.Where(qitem => qitem.SpecificationId == item.Id)?.ToList() ?? new List<RB_Groupbuy_Activity_Specificationvalue_Extend>();
                    }
                }
                //规格价格列表
                List<RB_Groupbuy_Activity_Specificationprice_Extend> specPriceList = GetGroupbuyActivitySpecificationpriceListModule(new RB_Groupbuy_Activity_Specificationprice_Extend()
                {
                    MallBaseId = query.MallBaseId,
                    TenantId = query.TenantId,
                    GoodsId = extModel.GoodId,
                });
                if (specPriceList != null && specPriceList.Count > 0)
                {
                    foreach (var item in specPriceList)
                    {
                        int SortNum = 1;
                        if (!string.IsNullOrEmpty(item.SpecificationSort))
                        {
                            item.AttrList = GetGroupBuyGoodsAttr(item.SpecificationSort, specificationList); ;
                        }
                        item.SortNum = SortNum;
                        SortNum++;
                    }
                }

                //拼团阶梯基础设置列表
                List<RB_Groupbuy_Activity_Step_Extend> groupStepList = GetGroupBuyActivityListModule(new RB_Groupbuy_Activity_Step_Extend()
                {
                    MallBaseId = query.MallBaseId,
                    TenantId = query.TenantId,
                    GoodId = extModel.GoodId,
                });
                //拼团阶梯价格设置列表
                List<RB_Groupbuy_Activity_Step_Price_Extend> StepPriceList = GetGroupbuyActivitySpecificationpriceListModule(new RB_Groupbuy_Activity_Step_Price_Extend()
                {
                    MallBaseId = query.MallBaseId,
                    TenantId = query.TenantId,
                    GoodId = extModel.GoodId,
                });

                //分销佣金列表
                List<RB_GroupBuy_Distributioncommission_Extend> commissionList = GetGroupBuyCommissionModule(new RB_GroupBuy_Distributioncommission_Extend()
                {
                    MallBaseId = query.MallBaseId,
                    TenantId = query.TenantId,
                    GoodsId = extModel.GoodId,
                });
                //会员价设置列表
                List<RB_Groupbuy_Memberprice_Extend> memberpriceList = GetGroupBuyMemberpriceModule(new RB_Groupbuy_Memberprice_Extend()
                {
                    MallBaseId = query.MallBaseId,
                    TenantId = query.TenantId,
                    GoodsId = extModel.GoodId,
                });

               

                if (groupStepList != null && groupStepList.Count > 0)
                {
                    foreach (var item in groupStepList)
                    {
                        item.StepPriceList = StepPriceList?.Where(qitem => qitem.StepId == item.StepId)?.ToList() ?? new List<RB_Groupbuy_Activity_Step_Price_Extend>();
                        foreach (var subItem in item.StepPriceList)
                        {
                            int SortNum = 1;
                            if (!string.IsNullOrEmpty(subItem.SpecificationSort))
                            {
                                subItem.AttrList = GetGroupBuyGoodsAttr(subItem.SpecificationSort, specificationList);
                            }
                            subItem.SortNum = SortNum;
                            SortNum++;
                        }
                        //分销普通类型
                        if (extModel.SeparateDistributionType == 1)
                        {
                            item.DistributioncommissionList = commissionList?.Where(qitem => qitem.StepId == item.StepId)?.ToList() ?? new List<RB_GroupBuy_Distributioncommission_Extend>();
                        }
                        //分销详细设置
                        else if (extModel.SeparateDistributionType == 2)
                        {
                            item.DistributionCommissionTreeList = new List<RB_GroupBuy_Distributioncommission_Extend>();
                            var gradeList = commissionList.Where(qitem => qitem.StepId == item.StepId).GroupBy(qitem => new { qitem.SpecificationSort, qitem.StepId }).ToList();
                            foreach (var subItem in gradeList)
                            {
                                var tempModel = commissionList.Where(qitem => qitem.StepId == subItem.Key.StepId && qitem.SpecificationSort == subItem.Key.SpecificationSort).FirstOrDefault();
                                item.DistributionCommissionTreeList.Add(new RB_GroupBuy_Distributioncommission_Extend()
                                {
                                    SpecificationSort = tempModel.SpecificationSort,
                                    GradeCommissionList =
                                    commissionList.Where(qitem => qitem.StepId == subItem.Key.StepId && qitem.SpecificationSort == subItem.Key.SpecificationSort)
                                    .OrderBy(qitem => qitem.DistributorGrade).ToList()
                                });
                            }
                            foreach (var subItem in item.DistributionCommissionTreeList)
                            {
                                if (!string.IsNullOrWhiteSpace(subItem.SpecificationSort))
                                {
                                    subItem.AttrList = GetGroupBuyGoodsAttr(subItem.SpecificationSort, specificationList);
                                }
                            }
                        }
                        //会员价设置
                        item.MemberpriceList = new List<RB_Groupbuy_Memberprice_Extend>();
                        var gradeMemberList = memberpriceList.Where(qitem => qitem.StepId == item.StepId).GroupBy(qitem => new { qitem.SpecificationSort, qitem.StepId }).ToList();
                        foreach (var subItem in gradeMemberList)
                        {
                            var tempModel = memberpriceList.Where(qitem => qitem.StepId == subItem.Key.StepId && qitem.SpecificationSort == subItem.Key.SpecificationSort).FirstOrDefault();
                            item.MemberpriceList.Add(new RB_Groupbuy_Memberprice_Extend()
                            {
                                SpecificationSort = tempModel.SpecificationSort,
                                GradeMemberPriceList =
                                memberpriceList.Where(qitem => qitem.StepId == subItem.Key.StepId && qitem.SpecificationSort == subItem.Key.SpecificationSort)
                                .OrderBy(qitem => qitem.MemberGrade).ToList()
                            });
                        }
                        foreach (var subItem in item.MemberpriceList)
                        {
                            if (!string.IsNullOrWhiteSpace(subItem.SpecificationSort))
                            {
                                subItem.AttrList = GetGroupBuyGoodsAttr(subItem.SpecificationSort, specificationList);
                            }
                        }
                    }
                }
                extModel.AreaList = new List<RB_GroupBuy_Area_Extend>();
                if (extModel.Is_Area_Limit == 1)
                {
                    extModel.AreaList = GetGroupBuyAreaModule(new RB_GroupBuy_Area_Extend()
                    {
                        MallBaseId = query.MallBaseId,
                        TenantId = query.TenantId,
                        GoodsId = extModel.GoodId,
                    });
                }
                extModel.SpecificationList = specificationList;
                extModel.SpecificationPriceList = specPriceList;
                extModel.GroupList = groupStepList;
            }
            return extModel;
        }

        /// <summary>
        /// 获取拼团商品的商品规格属性
        /// </summary>
        /// <param name="SpecificationSort">商品规格</param>
        /// <param name="specificationList">规格值</param>
        /// <returns></returns>
        public List<object> GetGroupBuyGoodsAttr(string SpecificationSort, List<RB_Groupbuy_Activity_Specification_Extend> specificationList)
        {
            List<object> AttrList = new List<object>();
            if (!string.IsNullOrEmpty(SpecificationSort))
            {
                var ssarr = SpecificationSort.Split(':');
                int Sort = Convert.ToInt32(ssarr[0]);
                string pic_url = specificationList[0].SpecificationValueList.Where(x => x.Sort == Sort).FirstOrDefault()?.ImagePath;
                for (int i = 0; i < ssarr.Length; i++)
                {
                    var smodel = specificationList[i];
                    var svmodel = smodel.SpecificationValueList.Where(x => x.Sort == Convert.ToInt32(ssarr[i])).FirstOrDefault();
                    AttrList.Add(new
                    {
                        SName = smodel.Name,
                        SId = smodel.Id,
                        SVId = svmodel?.Sort ?? 0,
                        SVName = svmodel?.Name ?? "",
                    });
                }
            }
            return AttrList;
        }
    }
}