﻿using Mall.Model.Extend.BaseSetUp;
using Mall.Repository.BaseSetUp;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Module.BaseSetUp
{
    /// <summary>
    /// 营销中心插件配置处理类
    /// </summary>
    public class MarketingPlugModule
    {
        /// <summary>
        /// 营销中心插件配置仓储层对象
        /// </summary>
        private readonly RB_Marketing_PlugRepository marketing_PlugRepository = new RB_Marketing_PlugRepository();

        /// <summary>
        /// 获取营销中心插件配置分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Marketing_Plug_Extend> GetMarketingPlugPageModule(int pageIndex, int pageSize, out long rowsCount, RB_Marketing_Plug_Extend query)
        {
            return marketing_PlugRepository.GetMarketingPlugPageRepository(pageIndex, pageSize, out rowsCount, query);
        }


        /// <summary>
        /// 获取营销中心插件配置列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Marketing_Plug_Extend> GetMarketingPlugListModule(RB_Marketing_Plug_Extend query)
        {
            return marketing_PlugRepository.GetMarketingPlugListRepository(query);
        }

        /// <summary>
        /// 新增修改营销中心插件配置
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetMarketingPlugModule(RB_Marketing_Plug_Extend extModel)
        {
            bool flag;
            if (extModel.PId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Marketing_Plug_Extend.PlugName),extModel.PlugName },
                    {nameof(RB_Marketing_Plug_Extend.PlugSubName),extModel.PlugSubName },
                    {nameof(RB_Marketing_Plug_Extend.PlugUrl),extModel.PlugUrl },
                    {nameof(RB_Marketing_Plug_Extend.Icon),extModel.Icon },
                    {nameof(RB_Marketing_Plug_Extend.IconClass),extModel.IconClass },
                };
                flag = marketing_PlugRepository.Update(fileds, new WhereHelper(nameof(RB_Marketing_Plug_Extend.PId), extModel.PId));
            }
            else
            {
                var newId = marketing_PlugRepository.Insert(extModel);
                extModel.PId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 根据编号获取营销中心插件配置实体
        /// </summary>
        /// <param name="PId"></param>
        /// <returns></returns>
        public RB_Marketing_Plug_Extend GetMarketingPlugModule(object PId)
        {
            return marketing_PlugRepository.GetEntity<RB_Marketing_Plug_Extend>(PId);
        }

        /// <summary>
        /// 删除营销中心插件配置
        /// </summary>
        /// <param name="PId"></param>
        /// <param name="Status"></param>
        /// <returns></returns>
        public bool RemoveMarketingPlugModule(object PId, int Status)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Marketing_Plug_Extend.Status),Status },
            };
            bool flag = marketing_PlugRepository.Update(fileds, new WhereHelper(nameof(RB_Marketing_Plug_Extend.PId), PId));
            return flag;
        }
    }
}

