﻿using Mall.Common.Enum;
using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Extend.BaseSetUp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Mall.Repository.BaseSetUp
{
    /// <summary>
    /// 营销中心插件配置仓储层
    /// </summary>
    public class RB_Marketing_PlugRepository : BaseRepository<RB_Marketing_Plug>
    {
        /// <summary>
        /// 获取营销中心插件配置分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Marketing_Plug_Extend> GetMarketingPlugPageRepository(int pageIndex, int pageSize, out long rowsCount, RB_Marketing_Plug_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            DynamicParameters parameters = new DynamicParameters();
            builder.Append(@" SELECT * FROM rb_marketing_plug WHERE 1=1 ");
            if (query != null)
            {
                if (!string.IsNullOrEmpty(query.PlugName))
                {
                    builder.Append($" AND {nameof(RB_Marketing_Plug_Extend.PlugName)} LIKE @PlugName ");
                    parameters.Add("PlugName", "%" + query.PlugName.Trim() + "%");
                }
                if (!string.IsNullOrEmpty(query.PlugSubName))
                {
                    builder.Append($" AND {nameof(RB_Marketing_Plug_Extend.PlugSubName)} LIKE @PlugSubName ");
                    parameters.Add("PlugSubName", "%" + query.PlugSubName.Trim() + "%");
                }
                if (query.PId > 0)
                {
                    builder.Append($" AND {nameof(RB_Marketing_Plug_Extend.PId)} ={query.PId} ");
                }
            }
            return GetPage<RB_Marketing_Plug_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }


        /// <summary>
        /// 获取营销中心插件配置列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Marketing_Plug_Extend> GetMarketingPlugListRepository(RB_Marketing_Plug_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            DynamicParameters parameters = new DynamicParameters();
            builder.Append(@" SELECT * FROM rb_marketing_plug WHERE 1=1 ");
            builder.AppendFormat($" AND {nameof(RB_Marketing_Plug_Extend.Status)}={(int)DateStateEnum.Normal} ");
            if (query != null)
            {
                if (!string.IsNullOrEmpty(query.PlugName))
                {
                    builder.Append($" AND {nameof(RB_Marketing_Plug_Extend.PlugName)} LIKE @PlugName ");
                    parameters.Add("PlugName", "%" + query.PlugName.Trim() + "%");
                }
                if (!string.IsNullOrEmpty(query.PlugSubName))
                {
                    builder.Append($" AND {nameof(RB_Marketing_Plug_Extend.PlugSubName)} LIKE @PlugSubName ");
                    parameters.Add("PlugSubName", "%" + query.PlugSubName.Trim() + "%");
                }
                if (query.PId > 0)
                {
                    builder.Append($" AND {nameof(RB_Marketing_Plug_Extend.PId)} ={query.PId} ");
                }
            }
            return Get<RB_Marketing_Plug_Extend>(builder.ToString(),parameters).ToList();
        }
    }
}
