﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 粉象返佣等级表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Distributor_FXGrade
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 等级
        /// </summary>        
        public int? Grade
        {
            get;
            set;
        }
        /// <summary>
        /// GradeName
        /// </summary>        
        public string GradeName
        {
            get;
            set;
        }
        /// <summary>
        /// 会员类型  1普通会员  2其他会员  3Vip
        /// </summary>        
        public int? IsGuest
        {
            get;
            set;
        }
        /// <summary>
        /// 返佣比例
        /// </summary>        
        public decimal? CommissionRatio
        {
            get;
            set;
        }
        /// <summary>
        /// 同级返佣比例
        /// </summary>        
        public decimal? SiblingRatio
        {
            get;
            set;
        }
        /// <summary>
        /// 可以拿同级返佣的数量
        /// </summary>        
        public int? SiblingRebatesNum
        {
            get;
            set;
        }
        /// <summary>
        /// 是否可以购买  1是  2否
        /// </summary>        
        public int? IsCanBuy
        {
            get;
            set;
        }
        /// <summary>
        /// 购买价格
        /// </summary>        
        public decimal? BuyMoney
        {
            get;
            set;
        }
        /// <summary>
        /// 是否可以自动升级   1是 2否
        /// </summary>        
        public int? IsUpgrade
        {
            get;
            set;
        }
        /// <summary>
        /// 升级所需下级数量
        /// </summary>        
        public int? UpgradeNum
        {
            get;
            set;
        }
        /// <summary>
        /// 升级所需下级等级id
        /// </summary>        
        public int? UpgradeId
        {
            get;
            set;
        }
        /// <summary>
        /// 删除状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 小数类型   1取整（向上进一）  2保留两位小数 
        /// </summary>
        public int? DecimalType { get; set; }
        /// <summary>
        /// 年
        /// </summary>
        public int? Year { get; set; }
        /// <summary>
        /// 会员权益描述
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// 粉象等级图标
        /// </summary>
        public string Icon { get; set; }

        /// <summary>
        /// 返佣类型  1正常返佣   2购买抵扣
        /// </summary>
        public int? CommissionType { get; set; }
    }
}
