﻿using Mall.Common.AOP;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 小程序实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public  class RB_MiniProgram
    {
        /// <summary>
        /// 小程序主键Id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }

        /// <summary>
        /// 商户号
        /// </summary>        
        public int? TenantId
        {
            get;
            set;
        }

        /// <summary>
        /// 商城名称
        /// </summary>        
        public string MallName
        {
            get;
            set;
        }

        /// <summary>
        /// 是否永久有效(1-永久有效）
        /// </summary>        
        public int? IsEffective
        {
            get;
            set;
        }

        /// <summary>
        /// 商城有效期
        /// </summary>        
        public DateTime? MallValidate
        {
            get;
            set;
        }

        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }

        /// <summary>
        /// 状态(0-正常，1-禁用)
        /// </summary>
        public int Status { get; set; }
    }
}
