﻿using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Extend.BaseSetUp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.BaseSetUp
{
    public class RB_LogisticsRulesRegionRepository : RepositoryBase<RB_LogisticsRulesRegion>
    {
        // <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_LogisticsRulesRegion); } }

        // <summary>
        /// 表名称
        /// </summary>
        public string DestinationTableName { get { return nameof(RB_Destination); } }

        /// <summary>
        /// 获取小程序列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_LogisticsRulesRegion_Extend> GetListRepository(RB_LogisticsRulesRegion_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT a.*,b.`Name` as RegionName FROM {TableName} as a LEFT JOIN {DestinationTableName} as b on a.RegionId=b.ID WHERE 1=1 ");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_LogisticsRulesRegion_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_LogisticsRulesRegion_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.RulesPriceId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_LogisticsRulesRegion_Extend.RulesPriceId)}={query.RulesPriceId}");
                }
                if (!string.IsNullOrWhiteSpace(query.PriceIds))
                {
                    builder.Append($" AND a.{nameof(RB_LogisticsRulesRegion_Extend.RulesPriceId)} in ({query.PriceIds})");
                }
            }
            return Get<RB_LogisticsRulesRegion_Extend>(builder.ToString()).ToList();
        }
    }
}
