﻿using Mall.Common.AOP;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Property
{
    /// <summary>
    /// 资产管理授权实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_ERP_Authorize
    {
        public int ID { get; set; }

        /// <summary>
        /// 商户id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 状态1待审核，2-已审核，3-已拒绝，4-已作废
        /// </summary>

        public int Status { get; set; }

        public DateTime? CreateDate { get; set; }
        public DateTime? UpdateDate { get; set; }

        public int CreateBy { get; set; }


        /// <summary>
        /// 类型2-集团，1-员工
        /// </summary>
        public int Type { get; set; }


        /// <summary>
        /// 商城中的用户id
        /// </summary>
        public int MallUserId { get; set; }


        /// <summary>
        /// 域名
        /// </summary>
        public string DomainName { get; set; }

        /// <summary>
        /// 账号
        /// </summary>
        public string Account { get; set; }

        /// <summary>
        /// 密码
        /// </summary>
        public string Password { get; set; }


        ///// <summary>
        ///// erp账号id
        ///// </summary>
        //public int ERPUserId { get; set; }


        /// <summary>
        /// erp集团id
        /// </summary>
        public int ERPGroupId { get; set; }

    }
}
