﻿using Mall.Model.Entity.Property;
using Mall.Model.Extend.Property;
using Mall.Repository.Property;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Module.Property
{
    public class AuthorizeModule
    {

        /// <summary>
        /// 授权仓储层
        /// </summary>
        private readonly RB_ERP_AuthorizeRepository authorizeRepository = new RB_ERP_AuthorizeRepository();
        /// <summary>
        /// erp用户仓储层
        /// </summary>
        private readonly Rb_employeeRepository employeeRepository = new Rb_employeeRepository();


        /// <summary>
        /// 集团仓储层
        /// </summary>
        private readonly Rb_Group_Repository groupRepository = new Rb_Group_Repository();


        #region 用户/集团授权
        /// <summary>
        /// 授权分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_ERP_Authorize_Extend> GetAuthorizePageList(int pageIndex, int pageSize, out long rowCount, RB_ERP_Authorize_Extend query)
        {
            return authorizeRepository.GetAuthorizePageList(pageIndex, pageSize, out rowCount, query);
        }


        /// <summary>
        /// 授权列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_ERP_Authorize_Extend> GetAuthorizeList(RB_ERP_Authorize_Extend query)
        {
            return authorizeRepository.GetAuthorizeList(query);
        }

        public bool AddERPAuthorize(RB_ERP_Authorize model)
        {
            if (model.ID == 0)
            {
                return authorizeRepository.Insert(model);
            }
            return false;
        }

        #endregion



        #region erp集团以及用户信息
        /// <summary>
        /// 根据where获取list
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Group_Extend> GetGroupList(RB_Group_Extend dmodel)
        {
            return groupRepository.GetList(dmodel);
        }

        /// <summary>
        /// 验证erp账号是否存在
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Employee_Extend> ValidateAdmin(RB_Employee_Extend dmodel)
        {
            return employeeRepository.ValidateAdmin(dmodel);
        }


        #endregion

    }
}
