﻿using Mall.Model.Entity.Property;
using Mall.Model.Extend.Property;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Property
{
    public class RB_ERP_AuthorizeRepository : RepositoryBase<RB_ERP_Authorize>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_ERP_Authorize); } }
        /// <summary>
        /// 授权分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_ERP_Authorize_Extend> GetAuthorizePageList(int pageIndex, int pageSize, out long rowCount, RB_ERP_Authorize_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT a.*,b.EmpName FROM {TableName} as a LEFT JOIN rb_employee as b on a.CreateBy=b.EmpId  WHERE  1=1");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND a.{nameof(RB_ERP_Authorize_Extend.ID)}={query.ID}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_ERP_Authorize_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_ERP_Authorize_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.Status > 0)
                {
                    builder.Append($" AND a.{nameof(RB_ERP_Authorize_Extend.Status)}={query.Status}");
                }
                if (query.Type > 0)
                {
                    builder.Append($" AND a.{nameof(RB_ERP_Authorize_Extend.Type)}={query.Type}");
                }
            }
            return GetPage<RB_ERP_Authorize_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 授权列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_ERP_Authorize_Extend> GetAuthorizeList(RB_ERP_Authorize_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT a.*,b.EmpName FROM {TableName} as a LEFT JOIN rb_employee as b on a.CreateBy=b.EmpId  WHERE  1=1");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND a.{nameof(RB_ERP_Authorize_Extend.ID)}={query.ID}");
                }
                if (query.Status > 0)
                {
                    builder.Append($" AND a.{nameof(RB_ERP_Authorize_Extend.Status)}={query.Status}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_ERP_Authorize_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_ERP_Authorize_Extend.MallBaseId)}={query.MallBaseId}");
                }

            }
            return Get<RB_ERP_Authorize_Extend>(builder.ToString()).ToList();
        }
    }
}
