﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Model.Extend.User;
using Mall.Module.User;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Mall.Common.Plugin;
using Mall.Common.Enum.User;
using Mall.CacheManager.User;
using Newtonsoft.Json.Linq;
using Mall.Common;
using Microsoft.AspNetCore.Authorization;
using Mall.Model.Entity.User;

namespace Mall.WebApi.Controllers.User
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class MContentController : BaseController
    {
        /// <summary>
        /// 内容管理
        /// </summary>
        private Module.User.ContentModule contentModule = new ContentModule();

        #region 专题分类

        /// <summary>
        /// 专题分类分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetTopicTypePageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Topic_Type_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetTopicTypePageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取专题分类列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetTopicTypeList()
        {
            var query = JsonConvert.DeserializeObject<RB_Topic_Type_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetTopicTypeListModule( query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 新增修改专题分类
        /// </summary>
        /// <returns></returns>
        public ApiResult SetTopicType()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Topic_Type_Extend>(RequestParm.msg.ToString());
            extModel.Status = 0;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            extModel.CreateDate = DateTime.Now;
            var flag = contentModule.SetTopicTypeModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取专题分类实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetTopicType()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = contentModule.GetTopicTypeModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除专题分类
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveTopicType()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var flag = contentModule.RemoveTopicTypeModule(Id);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 更新专题分类状态
        /// </summary>
        /// <returns></returns>
        public ApiResult UpdateTopicTypeStatus()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var IsDisable = parms.GetInt("IsDisable");
            var flag = contentModule.UpdateTopicTypeStatusModule(Id, IsDisable);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        #endregion

        #region 门店

        /// <summary>
        /// 门店分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetStoresPageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Stores_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetStoresPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 门店分类列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetStoresList()
        {
            var query = JsonConvert.DeserializeObject<RB_Stores_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetStoresListModule(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 新增修改门店
        /// </summary>
        /// <returns></returns>
        public ApiResult SetStores()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Stores_Extend>(RequestParm.msg.ToString());
            extModel.Status = 0;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            extModel.CreateDate = DateTime.Now;
            var flag = contentModule.SetStoresModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取门店实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetStores()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = contentModule.GetStoresModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除门店
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveStores()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var flag = contentModule.RemoveStoresModule(Id);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        #endregion

        #region 视频

        /// <summary>
        /// 视频分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetVideoPageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Video_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetVideoPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取视频列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetVideoListModule()
        {
            var query = JsonConvert.DeserializeObject<RB_Video_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetVideoListModule(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 新增修改视频
        /// </summary>
        /// <returns></returns>
        public ApiResult SetVideo()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Video_Extend>(RequestParm.msg.ToString());
            extModel.Status = 0;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            extModel.CreateDate = DateTime.Now;
            var flag = contentModule.SetVideoModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取视频实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetVideo()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = contentModule.GetVideoModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除视频
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveVideo()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var flag = contentModule.RemoveVideoModule(Id);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        #endregion

        #region 文章

        /// <summary>
        /// 文章分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetArticlePageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Article_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetArticlePageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取文章列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetArticleList()
        {
            var query = JsonConvert.DeserializeObject<RB_Article_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetArticleListModule(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 新增修改文章
        /// </summary>
        /// <returns></returns>
        public ApiResult SetArticle()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Article_Extend>(RequestParm.msg.ToString());
            extModel.Status = 0;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            extModel.CreateDate = DateTime.Now;
            var flag = contentModule.SetArticleModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取文章实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetArticle()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = contentModule.GetArticleModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除文章
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveArticle()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var flag = contentModule.RemoveArticleModule(Id);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 更新文章状态
        /// </summary>
        /// <returns></returns>
        public ApiResult UpdateArticleStatus()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var IsDisable = parms.GetInt("IsDisable");
            var flag = contentModule.UpdateArticleIsDisableModule(Id, IsDisable);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        #endregion
    }
}