﻿using Mall.Common.Enum;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 榜单报名仓储层
    /// </summary>
    public class RB_FirstShop_ListEnrollRepository : BaseRepository<RB_FirstShop_ListEnroll>
    {
        /// <summary>
        /// 获取分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_FirstShop_ListEnroll_Extend> GetPageList(int pageIndex, int pageSize, out long count, RB_FirstShop_ListEnroll_Extend dmodel)
        {
            var parameters = new DynamicParameters();
            string where = $" 1=1 and Status =0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_ListEnroll_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_ListEnroll_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_ListEnroll_Extend.UserId)}={dmodel.UserId}";
            }
            if (dmodel.ObjectType > 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_ListEnroll_Extend.ObjectType)}={dmodel.ObjectType}";
            }
            if (dmodel.CandidateState > 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_ListEnroll_Extend.CandidateState)}={dmodel.CandidateState}";
            }
            if (dmodel.RankListState > 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_ListEnroll_Extend.RankListState)}={dmodel.RankListState}";
            }

            string sql = $@"select w.*,u.Name as UserName from RB_FirstShop_ListEnroll w
left join rb_member_user u on w.UserId = u.Id
where {where} order by w.Id desc
";
            return GetPage<RB_FirstShop_ListEnroll_Extend>(pageIndex, pageSize, out count, sql, parameters).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_FirstShop_ListEnroll_Extend> GetList(RB_FirstShop_ListEnroll_Extend dmodel)
        {
            var parameters = new DynamicParameters();
            string where = $" 1=1 and Status =0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_ListEnroll_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_ListEnroll_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.ListId > 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_ListEnroll_Extend.ListId)}={dmodel.ListId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_ListEnroll_Extend.UserId)}={dmodel.UserId}";
            }
            if (dmodel.ObjectType > 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_ListEnroll_Extend.ObjectType)}={(int)dmodel.ObjectType}";
            }
            if (dmodel.CandidateState > 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_ListEnroll_Extend.CandidateState)}={dmodel.CandidateState}";
            }
            if (!string.IsNullOrWhiteSpace(dmodel.ObjectIds))
            {
                where += $@" and w.{nameof(RB_FirstShop_ListEnroll_Extend.ObjectId)} in ({dmodel.ObjectIds})";
            }
            if (dmodel.RankListState > 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_ListEnroll_Extend.RankListState)}={dmodel.RankListState}";
            }

            string sql = $@"select w.*,u.Name as UserName from RB_FirstShop_ListEnroll w
left join rb_member_user u on w.UserId = u.Id
where {where} order by w.Id desc
";
            return Get<RB_FirstShop_ListEnroll_Extend>(sql, parameters).ToList();
        }

    }
}