﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Common.API
{
    /// <summary>
    /// Api返回结果枚举
    /// </summary>
    public enum ResultCode
    {
        /// <summary>
        /// 服务器异常
        /// </summary>
        AbnormalServer = -1,
        /// <summary>
        /// 请求成功
        /// </summary>
        Success = 1,
        /// <summary>
        /// 操作失败
        /// </summary>
        Fail = 0,

        /// <summary>
        /// 服务器返回提示用户信息，询问用户是否继续操作
        /// </summary>
        Tip = 2,

        /// <summary>
        /// Toneken过期
        /// </summary>
        TokenOverdue = 10000,
        /// <summary>
        /// Token不合法
        /// </summary>
        TokenIllegal = 10001,
        /// <summary>
        /// 请求过期
        /// </summary>
        RequestOverdue = 10002,
        /// <summary>
        /// 签名不合法
        /// </summary>
        SignIllegal = 10003,
        /// <summary>
        /// 请求参数为空
        /// </summary>
        ParamIsNull = 10004,
        /// <summary>
        /// 没有权限
        /// </summary>
        NoPermission = 10005,
        /// <summary>
        /// 账号未绑定手机号
        /// </summary>
        AccountNotBindMobile = 10006,
        /// <summary>
        /// 账号未激活
        /// </summary>
        AccountNotActivation = 10007,
        /// <summary>
        /// 账号未绑定openid
        /// </summary>
        AccountNotBindOpenId = 10008,
        /// <summary>
        /// 表单重复提交
        /// </summary>
        FormRepeatSubmit = 10009,
        /// <summary>
        /// 不在打卡范围
        /// </summary>
        NotInCardRange = 20001,
        /// <summary>
        /// 未上传工作报告
        /// </summary>
        NotSendWorkLog = 20002,
        /// <summary>
        /// 第三方酒店订单返回价格错误(第三方返回的错误代码11018)
        /// </summary>
        PriceErro = 11018,
        /// <summary>
        ///财务未找到下一个审核人
        /// </summary>
        NoPeople = 11019
    }
}
