﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using Mall.Common;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Entity.Product;
using Mall.Model.Entity.User;
using Mall.Model.Extend.Product;
using Mall.Model.Extend.Property;
using Mall.Model.Extend.User;
using Mall.Model.Query;
using Mall.Repository;
using Mall.Repository.BaseSetUp;
using Mall.Repository.Product;
using Mall.Repository.Property;
using Mall.Repository.User;
using Newtonsoft.Json;

namespace Mall.Module.Property
{
    /// <summary>
    /// 商品处理层
    /// </summary>
    public class PropertyModule
    {
        
        /// <summary>
        /// 商品分类
        /// </summary>
        private readonly RB_Product_CategoryRepository product_CategoryRepository = new RB_Product_CategoryRepository();
        /// <summary>
        /// 商品
        /// </summary>
        private readonly RB_GoodsRepository goodsRepository = new RB_GoodsRepository();
        /// <summary>
        /// 商品分类
        /// </summary>
        private readonly RB_Goods_CategoryRepository goods_CategoryRepository = new RB_Goods_CategoryRepository();
        /// <summary>
        /// 商品规格
        /// </summary>
        private readonly RB_Goods_SpecificationRepository goods_SpecificationRepository = new RB_Goods_SpecificationRepository();
        /// <summary>
        /// 商品规格值
        /// </summary>
        private readonly RB_Goods_SpecificationValueRepository goods_SpecificationValueRepository = new RB_Goods_SpecificationValueRepository();
        /// <summary>
        /// 物料档案
        /// </summary>
        private readonly RB_Supplies_MaterialRepository supplies_MaterialRepository = new RB_Supplies_MaterialRepository();
        /// <summary>
        /// 物料库存
        /// </summary>
        private readonly RB_Supplies_InventoryRepository supplies_InventoryRepository = new RB_Supplies_InventoryRepository();


        #region 获取资产物料列表

        /// <summary>
        /// 获取物料档案分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="demodel"></param>
        /// <param name="count"></param>
        /// <returns></returns>
        public List<RB_Supplies_Material_Extend> GetMaterialPageList(int pageIndex, int pageSize, RB_Supplies_Material_Extend demodel, out long count)
        {
            var list = supplies_MaterialRepository.GetPageList(pageIndex, pageSize, demodel, out count);
            List<RB_Supplies_Inventory_Extend> iList = new List<RB_Supplies_Inventory_Extend>();
            if (demodel.WareHouseId > 0 && list.Any())
            {
                //查询出该仓库  耗材下 所有的库存
                string Sstr = string.Join(",", list.Select(x => x.Id).Distinct());
                iList = supplies_InventoryRepository.GetList(new RB_Supplies_Inventory_Extend() { RB_Group_Id = demodel.RB_Group_Id, WarehouseIdStr = demodel.WareHouseId.Value.ToString(), SuppliesIdStr = Sstr });
            }
            foreach (var item in list)
            {
                if (item.Images == "" || item.Images == null)
                {
                    item.Images = "[]";
                }
                var imglist = JsonConvert.DeserializeObject<List<string>>(item.Images);
                item.ImageList = new List<string>();
                foreach (var img in imglist)
                {
                    item.ImageList.Add(Config.GetFileUrl(img));
                }
                item.InventoryNum = iList.Where(x => x.SuppliesId == item.Id).FirstOrDefault()?.Number ?? 0;
            }
            return list;
        }

        #endregion
    }
}
